package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LabelSelector;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import java.lang.Object;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import java.lang.Boolean;
import java.util.Map;

public interface ClusterResourceQuotaSelectorFluent<A extends ClusterResourceQuotaSelectorFluent<A>> extends Fluent<A> {


    public A addToAnnotations(String key,String value);
    public A addToAnnotations(Map<String,String> map);
    public A removeFromAnnotations(String key);
    public A removeFromAnnotations(Map<String,String> map);
    public Map<String,String> getAnnotations();
    public A withAnnotations(Map<String,String> annotations);
    public Boolean hasAnnotations();
    
/**
 * This method has been deprecated, please use method buildLabels instead.
 * @return The buildable object.
 */
@Deprecated public LabelSelector getLabels();
    public LabelSelector buildLabels();
    public A withLabels(LabelSelector labels);
    public Boolean hasLabels();
    public ClusterResourceQuotaSelectorFluent.LabelsNested<A> withNewLabels();
    public ClusterResourceQuotaSelectorFluent.LabelsNested<A> withNewLabelsLike(LabelSelector item);
    public ClusterResourceQuotaSelectorFluent.LabelsNested<A> editLabels();
    public ClusterResourceQuotaSelectorFluent.LabelsNested<A> editOrNewLabels();
    public ClusterResourceQuotaSelectorFluent.LabelsNested<A> editOrNewLabelsLike(LabelSelector item);
    public interface LabelsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,LabelSelectorFluent<ClusterResourceQuotaSelectorFluent.LabelsNested<N>> {

        public N and();
        public N endLabels();    }


}
