package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.EnvVar;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class DockerStrategyOptionsFluentImpl<A extends DockerStrategyOptionsFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements DockerStrategyOptionsFluent<A> {

    private List<EnvVar> buildArgs = new ArrayList<EnvVar>();
    private Boolean noCache;

    public DockerStrategyOptionsFluentImpl() { 
    }


    public DockerStrategyOptionsFluentImpl(DockerStrategyOptions instance) { 
        this.withBuildArgs(instance.getBuildArgs()); 
        this.withNoCache(instance.getNoCache()); 
    }


    public A addToBuildArgs(int index,EnvVar item) {
        if (this.buildArgs == null) {this.buildArgs = new ArrayList<EnvVar>();}
        this.buildArgs.add(index, item);
        return (A)this;
    }

    public A setToBuildArgs(int index,EnvVar item) {
        if (this.buildArgs == null) {this.buildArgs = new ArrayList<EnvVar>();}
        this.buildArgs.set(index, item); return (A)this;
    }

    public A addToBuildArgs(EnvVar... items) {
        if (this.buildArgs == null) {this.buildArgs = new ArrayList<EnvVar>();}
        for (EnvVar item : items) {this.buildArgs.add(item);} return (A)this;
    }

    public A addAllToBuildArgs(Collection<EnvVar> items) {
        if (this.buildArgs == null) {this.buildArgs = new ArrayList<EnvVar>();}
        for (EnvVar item : items) {this.buildArgs.add(item);} return (A)this;
    }

    public A removeFromBuildArgs(EnvVar... items) {
        for (EnvVar item : items) {if (this.buildArgs!= null){ this.buildArgs.remove(item);}} return (A)this;
    }

    public A removeAllFromBuildArgs(Collection<EnvVar> items) {
        for (EnvVar item : items) {if (this.buildArgs!= null){ this.buildArgs.remove(item);}} return (A)this;
    }

    public List<EnvVar> getBuildArgs() {
        return this.buildArgs;
    }

    public EnvVar getBuildArg(int index) {
        return this.buildArgs.get(index);
    }

    public EnvVar getFirstBuildArg() {
        return this.buildArgs.get(0);
    }

    public EnvVar getLastBuildArg() {
        return this.buildArgs.get(buildArgs.size() - 1);
    }

    public EnvVar getMatchingBuildArg(io.fabric8.kubernetes.api.builder.Predicate<EnvVar> predicate) {
        for (EnvVar item: buildArgs) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingBuildArg(io.fabric8.kubernetes.api.builder.Predicate<EnvVar> predicate) {
        for (EnvVar item: buildArgs) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withBuildArgs(List<EnvVar> buildArgs) {
        if (this.buildArgs != null) { _visitables.get("buildArgs").removeAll(this.buildArgs);}
        if (buildArgs != null) {this.buildArgs = new ArrayList<EnvVar>(); for (EnvVar item : buildArgs){this.addToBuildArgs(item);}} else { this.buildArgs = null;} return (A) this;
    }

    public A withBuildArgs(EnvVar... buildArgs) {
        if (this.buildArgs != null) {this.buildArgs.clear();}
        if (buildArgs != null) {for (EnvVar item :buildArgs){ this.addToBuildArgs(item);}} return (A) this;
    }

    public Boolean hasBuildArgs() {
        return buildArgs != null && !buildArgs.isEmpty();
    }

    public Boolean isNoCache() {
        return this.noCache;
    }

    public A withNoCache(Boolean noCache) {
        this.noCache=noCache; return (A) this;
    }

    public Boolean hasNoCache() {
        return this.noCache != null;
    }

    public A withNewNoCache(String arg1) {
        return (A)withNoCache(new Boolean(arg1));
    }

    public A withNewNoCache(boolean arg1) {
        return (A)withNoCache(new Boolean(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        DockerStrategyOptionsFluentImpl that = (DockerStrategyOptionsFluentImpl) o;
        if (buildArgs != null ? !buildArgs.equals(that.buildArgs) :that.buildArgs != null) return false;
        if (noCache != null ? !noCache.equals(that.noCache) :that.noCache != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(buildArgs,  noCache,  super.hashCode());
    }

}
