package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ClusterOperatorBuilder extends ClusterOperatorFluentImpl<ClusterOperatorBuilder> implements VisitableBuilder<ClusterOperator,ClusterOperatorBuilder> {

    ClusterOperatorFluent<?> fluent;
    Boolean validationEnabled;

    public ClusterOperatorBuilder() { 
        this(true);
    }


    public ClusterOperatorBuilder(Boolean validationEnabled) { 
        this(new ClusterOperator(), validationEnabled);
    }


    public ClusterOperatorBuilder(ClusterOperatorFluent<?> fluent) { 
        this(fluent, true);
    }


    public ClusterOperatorBuilder(ClusterOperatorFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new ClusterOperator(), validationEnabled);
    }


    public ClusterOperatorBuilder(ClusterOperatorFluent<?> fluent,ClusterOperator instance) { 
        this(fluent, instance, true);
    }


    public ClusterOperatorBuilder(ClusterOperatorFluent<?> fluent,ClusterOperator instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        fluent.withSpec(instance.getSpec()); 
        fluent.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }


    public ClusterOperatorBuilder(ClusterOperator instance) { 
        this(instance,true);
    }


    public ClusterOperatorBuilder(ClusterOperator instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withSpec(instance.getSpec()); 
        this.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }


    public ClusterOperator build() {
        ClusterOperator buildable = new ClusterOperator(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ClusterOperatorBuilder that = (ClusterOperatorBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
