package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.HasMetadata;
import java.lang.Deprecated;
import java.util.function.Predicate;
import java.util.List;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import java.util.Iterator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluent;
import java.lang.Boolean;
import java.lang.Object;
import java.util.Map;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.util.Collection;
import io.fabric8.kubernetes.api.builder.Nested;

public interface ClusterOperatorStatusFluent<A extends ClusterOperatorStatusFluent<A>> extends Fluent<A> {


    public A addToConditions(int index,ClusterOperatorStatusCondition item);
    public A setToConditions(int index,ClusterOperatorStatusCondition item);
    public A addToConditions(ClusterOperatorStatusCondition... items);
    public A addAllToConditions(Collection<ClusterOperatorStatusCondition> items);
    public A removeFromConditions(ClusterOperatorStatusCondition... items);
    public A removeAllFromConditions(Collection<ClusterOperatorStatusCondition> items);
    public A removeMatchingFromConditions(Predicate<ClusterOperatorStatusConditionBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildConditions instead.
 * @return The buildable object.
 */
@Deprecated public List<ClusterOperatorStatusCondition> getConditions();
    public List<ClusterOperatorStatusCondition> buildConditions();
    public ClusterOperatorStatusCondition buildCondition(int index);
    public ClusterOperatorStatusCondition buildFirstCondition();
    public ClusterOperatorStatusCondition buildLastCondition();
    public ClusterOperatorStatusCondition buildMatchingCondition(Predicate<ClusterOperatorStatusConditionBuilder> predicate);
    public Boolean hasMatchingCondition(Predicate<ClusterOperatorStatusConditionBuilder> predicate);
    public A withConditions(List<ClusterOperatorStatusCondition> conditions);
    public A withConditions(ClusterOperatorStatusCondition... conditions);
    public Boolean hasConditions();
    public A addNewCondition(String lastTransitionTime,String message,String reason,String status,String type);
    public ClusterOperatorStatusFluent.ConditionsNested<A> addNewCondition();
    public ClusterOperatorStatusFluent.ConditionsNested<A> addNewConditionLike(ClusterOperatorStatusCondition item);
    public ClusterOperatorStatusFluent.ConditionsNested<A> setNewConditionLike(int index,ClusterOperatorStatusCondition item);
    public ClusterOperatorStatusFluent.ConditionsNested<A> editCondition(int index);
    public ClusterOperatorStatusFluent.ConditionsNested<A> editFirstCondition();
    public ClusterOperatorStatusFluent.ConditionsNested<A> editLastCondition();
    public ClusterOperatorStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<ClusterOperatorStatusConditionBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildExtension instead.
 * @return The buildable object.
 */
@Deprecated public HasMetadata getExtension();
    public HasMetadata buildExtension();
    public A withExtension(HasMetadata extension);
    public Boolean hasExtension();
    public A withClusterVersionExtension(ClusterVersion clusterVersionExtension);
    public ClusterOperatorStatusFluent.ClusterVersionExtensionNested<A> withNewClusterVersionExtension();
    public ClusterOperatorStatusFluent.ClusterVersionExtensionNested<A> withNewClusterVersionExtensionLike(ClusterVersion item);
    public A withImageStreamImportExtension(ImageStreamImport imageStreamImportExtension);
    public ClusterOperatorStatusFluent.ImageStreamImportExtensionNested<A> withNewImageStreamImportExtension();
    public ClusterOperatorStatusFluent.ImageStreamImportExtensionNested<A> withNewImageStreamImportExtensionLike(ImageStreamImport item);
    public A withProxyExtension(Proxy proxyExtension);
    public ClusterOperatorStatusFluent.ProxyExtensionNested<A> withNewProxyExtension();
    public ClusterOperatorStatusFluent.ProxyExtensionNested<A> withNewProxyExtensionLike(Proxy item);
    public A withProjectExtension(Project projectExtension);
    public ClusterOperatorStatusFluent.ProjectExtensionNested<A> withNewProjectExtension();
    public ClusterOperatorStatusFluent.ProjectExtensionNested<A> withNewProjectExtensionLike(Project item);
    public A withClusterOperatorExtension(ClusterOperator clusterOperatorExtension);
    public ClusterOperatorStatusFluent.ClusterOperatorExtensionNested<A> withNewClusterOperatorExtension();
    public ClusterOperatorStatusFluent.ClusterOperatorExtensionNested<A> withNewClusterOperatorExtensionLike(ClusterOperator item);
    public A withBuildConfigExtension(BuildConfig buildConfigExtension);
    public ClusterOperatorStatusFluent.BuildConfigExtensionNested<A> withNewBuildConfigExtension();
    public ClusterOperatorStatusFluent.BuildConfigExtensionNested<A> withNewBuildConfigExtensionLike(BuildConfig item);
    public A withInfrastructureExtension(Infrastructure infrastructureExtension);
    public ClusterOperatorStatusFluent.InfrastructureExtensionNested<A> withNewInfrastructureExtension();
    public ClusterOperatorStatusFluent.InfrastructureExtensionNested<A> withNewInfrastructureExtensionLike(Infrastructure item);
    public A withSchedulerExtension(Scheduler schedulerExtension);
    public ClusterOperatorStatusFluent.SchedulerExtensionNested<A> withNewSchedulerExtension();
    public ClusterOperatorStatusFluent.SchedulerExtensionNested<A> withNewSchedulerExtensionLike(Scheduler item);
    public A withRangeAllocationExtension(RangeAllocation rangeAllocationExtension);
    public ClusterOperatorStatusFluent.RangeAllocationExtensionNested<A> withNewRangeAllocationExtension();
    public ClusterOperatorStatusFluent.RangeAllocationExtensionNested<A> withNewRangeAllocationExtensionLike(RangeAllocation item);
    public A withRouteExtension(Route routeExtension);
    public ClusterOperatorStatusFluent.RouteExtensionNested<A> withNewRouteExtension();
    public ClusterOperatorStatusFluent.RouteExtensionNested<A> withNewRouteExtensionLike(Route item);
    public A withClusterNetworkExtension(ClusterNetwork clusterNetworkExtension);
    public ClusterOperatorStatusFluent.ClusterNetworkExtensionNested<A> withNewClusterNetworkExtension();
    public ClusterOperatorStatusFluent.ClusterNetworkExtensionNested<A> withNewClusterNetworkExtensionLike(ClusterNetwork item);
    public A withOAuthAuthorizeTokenExtension(OAuthAuthorizeToken oAuthAuthorizeTokenExtension);
    public ClusterOperatorStatusFluent.OAuthAuthorizeTokenExtensionNested<A> withNewOAuthAuthorizeTokenExtension();
    public ClusterOperatorStatusFluent.OAuthAuthorizeTokenExtensionNested<A> withNewOAuthAuthorizeTokenExtensionLike(OAuthAuthorizeToken item);
    public A withOAuthExtension(OAuth oAuthExtension);
    public ClusterOperatorStatusFluent.OAuthExtensionNested<A> withNewOAuthExtension();
    public ClusterOperatorStatusFluent.OAuthExtensionNested<A> withNewOAuthExtensionLike(OAuth item);
    public A withOperatorHubExtension(OperatorHub operatorHubExtension);
    public ClusterOperatorStatusFluent.OperatorHubExtensionNested<A> withNewOperatorHubExtension();
    public ClusterOperatorStatusFluent.OperatorHubExtensionNested<A> withNewOperatorHubExtensionLike(OperatorHub item);
    public A withClusterRoleBindingExtension(ClusterRoleBinding clusterRoleBindingExtension);
    public ClusterOperatorStatusFluent.ClusterRoleBindingExtensionNested<A> withNewClusterRoleBindingExtension();
    public ClusterOperatorStatusFluent.ClusterRoleBindingExtensionNested<A> withNewClusterRoleBindingExtensionLike(ClusterRoleBinding item);
    public A withClusterResourceQuotaExtension(ClusterResourceQuota clusterResourceQuotaExtension);
    public ClusterOperatorStatusFluent.ClusterResourceQuotaExtensionNested<A> withNewClusterResourceQuotaExtension();
    public ClusterOperatorStatusFluent.ClusterResourceQuotaExtensionNested<A> withNewClusterResourceQuotaExtensionLike(ClusterResourceQuota item);
    public A withProjectRequestExtension(ProjectRequest projectRequestExtension);
    public ClusterOperatorStatusFluent.ProjectRequestExtensionNested<A> withNewProjectRequestExtension();
    public ClusterOperatorStatusFluent.ProjectRequestExtensionNested<A> withNewProjectRequestExtensionLike(ProjectRequest item);
    public A withTemplateExtension(Template templateExtension);
    public ClusterOperatorStatusFluent.TemplateExtensionNested<A> withNewTemplateExtension();
    public ClusterOperatorStatusFluent.TemplateExtensionNested<A> withNewTemplateExtensionLike(Template item);
    public A withOAuthClientAuthorizationExtension(OAuthClientAuthorization oAuthClientAuthorizationExtension);
    public ClusterOperatorStatusFluent.OAuthClientAuthorizationExtensionNested<A> withNewOAuthClientAuthorizationExtension();
    public ClusterOperatorStatusFluent.OAuthClientAuthorizationExtensionNested<A> withNewOAuthClientAuthorizationExtensionLike(OAuthClientAuthorization item);
    public A withClusterRoleExtension(ClusterRole clusterRoleExtension);
    public ClusterOperatorStatusFluent.ClusterRoleExtensionNested<A> withNewClusterRoleExtension();
    public ClusterOperatorStatusFluent.ClusterRoleExtensionNested<A> withNewClusterRoleExtensionLike(ClusterRole item);
    public A withImageTagExtension(ImageTag imageTagExtension);
    public ClusterOperatorStatusFluent.ImageTagExtensionNested<A> withNewImageTagExtension();
    public ClusterOperatorStatusFluent.ImageTagExtensionNested<A> withNewImageTagExtensionLike(ImageTag item);
    public A withDeploymentConfigExtension(DeploymentConfig deploymentConfigExtension);
    public ClusterOperatorStatusFluent.DeploymentConfigExtensionNested<A> withNewDeploymentConfigExtension();
    public ClusterOperatorStatusFluent.DeploymentConfigExtensionNested<A> withNewDeploymentConfigExtensionLike(DeploymentConfig item);
    public A withOAuthAccessTokenExtension(OAuthAccessToken oAuthAccessTokenExtension);
    public ClusterOperatorStatusFluent.OAuthAccessTokenExtensionNested<A> withNewOAuthAccessTokenExtension();
    public ClusterOperatorStatusFluent.OAuthAccessTokenExtensionNested<A> withNewOAuthAccessTokenExtensionLike(OAuthAccessToken item);
    public A withRoleBindingExtension(RoleBinding roleBindingExtension);
    public ClusterOperatorStatusFluent.RoleBindingExtensionNested<A> withNewRoleBindingExtension();
    public ClusterOperatorStatusFluent.RoleBindingExtensionNested<A> withNewRoleBindingExtensionLike(RoleBinding item);
    public A withImageExtension(Image imageExtension);
    public ClusterOperatorStatusFluent.ImageExtensionNested<A> withNewImageExtension();
    public ClusterOperatorStatusFluent.ImageExtensionNested<A> withNewImageExtensionLike(Image item);
    public A withAPIServerExtension(APIServer aPIServerExtension);
    public ClusterOperatorStatusFluent.APIServerExtensionNested<A> withNewAPIServerExtension();
    public ClusterOperatorStatusFluent.APIServerExtensionNested<A> withNewAPIServerExtensionLike(APIServer item);
    public A withPersistentVolumeClaimExtension(PersistentVolumeClaim persistentVolumeClaimExtension);
    public ClusterOperatorStatusFluent.PersistentVolumeClaimExtensionNested<A> withNewPersistentVolumeClaimExtension();
    public ClusterOperatorStatusFluent.PersistentVolumeClaimExtensionNested<A> withNewPersistentVolumeClaimExtensionLike(PersistentVolumeClaim item);
    public A withImageStreamMappingExtension(ImageStreamMapping imageStreamMappingExtension);
    public ClusterOperatorStatusFluent.ImageStreamMappingExtensionNested<A> withNewImageStreamMappingExtension();
    public ClusterOperatorStatusFluent.ImageStreamMappingExtensionNested<A> withNewImageStreamMappingExtensionLike(ImageStreamMapping item);
    public A withRoleExtension(Role roleExtension);
    public ClusterOperatorStatusFluent.RoleExtensionNested<A> withNewRoleExtension();
    public ClusterOperatorStatusFluent.RoleExtensionNested<A> withNewRoleExtensionLike(Role item);
    public A withFeatureGateExtension(FeatureGate featureGateExtension);
    public ClusterOperatorStatusFluent.FeatureGateExtensionNested<A> withNewFeatureGateExtension();
    public ClusterOperatorStatusFluent.FeatureGateExtensionNested<A> withNewFeatureGateExtensionLike(FeatureGate item);
    public A withUserExtension(User userExtension);
    public ClusterOperatorStatusFluent.UserExtensionNested<A> withNewUserExtension();
    public ClusterOperatorStatusFluent.UserExtensionNested<A> withNewUserExtensionLike(User item);
    public A withImageStreamImageExtension(ImageStreamImage imageStreamImageExtension);
    public ClusterOperatorStatusFluent.ImageStreamImageExtensionNested<A> withNewImageStreamImageExtension();
    public ClusterOperatorStatusFluent.ImageStreamImageExtensionNested<A> withNewImageStreamImageExtensionLike(ImageStreamImage item);
    public A withBuildExtension(Build buildExtension);
    public ClusterOperatorStatusFluent.BuildExtensionNested<A> withNewBuildExtension();
    public ClusterOperatorStatusFluent.BuildExtensionNested<A> withNewBuildExtensionLike(Build item);
    public A withRoleBindingRestrictionExtension(RoleBindingRestriction roleBindingRestrictionExtension);
    public ClusterOperatorStatusFluent.RoleBindingRestrictionExtensionNested<A> withNewRoleBindingRestrictionExtension();
    public ClusterOperatorStatusFluent.RoleBindingRestrictionExtensionNested<A> withNewRoleBindingRestrictionExtensionLike(RoleBindingRestriction item);
    public A withImageStreamTagExtension(ImageStreamTag imageStreamTagExtension);
    public ClusterOperatorStatusFluent.ImageStreamTagExtensionNested<A> withNewImageStreamTagExtension();
    public ClusterOperatorStatusFluent.ImageStreamTagExtensionNested<A> withNewImageStreamTagExtensionLike(ImageStreamTag item);
    public A withGroupExtension(io.fabric8.openshift.api.model.Group groupExtension);
    public ClusterOperatorStatusFluent.GroupExtensionNested<A> withNewGroupExtension();
    public ClusterOperatorStatusFluent.GroupExtensionNested<A> withNewGroupExtensionLike(io.fabric8.openshift.api.model.Group item);
    public A withImageSignatureExtension(ImageSignature imageSignatureExtension);
    public ClusterOperatorStatusFluent.ImageSignatureExtensionNested<A> withNewImageSignatureExtension();
    public ClusterOperatorStatusFluent.ImageSignatureExtensionNested<A> withNewImageSignatureExtensionLike(ImageSignature item);
    public A withAppliedClusterResourceQuotaExtension(AppliedClusterResourceQuota appliedClusterResourceQuotaExtension);
    public ClusterOperatorStatusFluent.AppliedClusterResourceQuotaExtensionNested<A> withNewAppliedClusterResourceQuotaExtension();
    public ClusterOperatorStatusFluent.AppliedClusterResourceQuotaExtensionNested<A> withNewAppliedClusterResourceQuotaExtensionLike(AppliedClusterResourceQuota item);
    public A withSecurityContextConstraintsExtension(SecurityContextConstraints securityContextConstraintsExtension);
    public ClusterOperatorStatusFluent.SecurityContextConstraintsExtensionNested<A> withNewSecurityContextConstraintsExtension();
    public ClusterOperatorStatusFluent.SecurityContextConstraintsExtensionNested<A> withNewSecurityContextConstraintsExtensionLike(SecurityContextConstraints item);
    public A withBuildRequestExtension(BuildRequest buildRequestExtension);
    public ClusterOperatorStatusFluent.BuildRequestExtensionNested<A> withNewBuildRequestExtension();
    public ClusterOperatorStatusFluent.BuildRequestExtensionNested<A> withNewBuildRequestExtensionLike(BuildRequest item);
    public A withEgressNetworkPolicyExtension(EgressNetworkPolicy egressNetworkPolicyExtension);
    public ClusterOperatorStatusFluent.EgressNetworkPolicyExtensionNested<A> withNewEgressNetworkPolicyExtension();
    public ClusterOperatorStatusFluent.EgressNetworkPolicyExtensionNested<A> withNewEgressNetworkPolicyExtensionLike(EgressNetworkPolicy item);
    public A withNetNamespaceExtension(NetNamespace netNamespaceExtension);
    public ClusterOperatorStatusFluent.NetNamespaceExtensionNested<A> withNewNetNamespaceExtension();
    public ClusterOperatorStatusFluent.NetNamespaceExtensionNested<A> withNewNetNamespaceExtensionLike(NetNamespace item);
    public A withImageStreamExtension(ImageStream imageStreamExtension);
    public ClusterOperatorStatusFluent.ImageStreamExtensionNested<A> withNewImageStreamExtension();
    public ClusterOperatorStatusFluent.ImageStreamExtensionNested<A> withNewImageStreamExtensionLike(ImageStream item);
    public A withOAuthClientExtension(OAuthClient oAuthClientExtension);
    public ClusterOperatorStatusFluent.OAuthClientExtensionNested<A> withNewOAuthClientExtension();
    public ClusterOperatorStatusFluent.OAuthClientExtensionNested<A> withNewOAuthClientExtensionLike(OAuthClient item);
    public A withIdentityExtension(Identity identityExtension);
    public ClusterOperatorStatusFluent.IdentityExtensionNested<A> withNewIdentityExtension();
    public ClusterOperatorStatusFluent.IdentityExtensionNested<A> withNewIdentityExtensionLike(Identity item);
    public A addToRelatedObjects(int index,io.fabric8.openshift.api.model.ObjectReference item);
    public A setToRelatedObjects(int index,io.fabric8.openshift.api.model.ObjectReference item);
    public A addToRelatedObjects(io.fabric8.openshift.api.model.ObjectReference... items);
    public A addAllToRelatedObjects(Collection<io.fabric8.openshift.api.model.ObjectReference> items);
    public A removeFromRelatedObjects(io.fabric8.openshift.api.model.ObjectReference... items);
    public A removeAllFromRelatedObjects(Collection<io.fabric8.openshift.api.model.ObjectReference> items);
    public A removeMatchingFromRelatedObjects(Predicate<io.fabric8.openshift.api.model.ObjectReferenceBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildRelatedObjects instead.
 * @return The buildable object.
 */
@Deprecated public List<io.fabric8.openshift.api.model.ObjectReference> getRelatedObjects();
    public List<io.fabric8.openshift.api.model.ObjectReference> buildRelatedObjects();
    public io.fabric8.openshift.api.model.ObjectReference buildRelatedObject(int index);
    public io.fabric8.openshift.api.model.ObjectReference buildFirstRelatedObject();
    public io.fabric8.openshift.api.model.ObjectReference buildLastRelatedObject();
    public io.fabric8.openshift.api.model.ObjectReference buildMatchingRelatedObject(Predicate<io.fabric8.openshift.api.model.ObjectReferenceBuilder> predicate);
    public Boolean hasMatchingRelatedObject(Predicate<io.fabric8.openshift.api.model.ObjectReferenceBuilder> predicate);
    public A withRelatedObjects(List<io.fabric8.openshift.api.model.ObjectReference> relatedObjects);
    public A withRelatedObjects(io.fabric8.openshift.api.model.ObjectReference... relatedObjects);
    public Boolean hasRelatedObjects();
    public A addNewRelatedObject(String group,String name,String namespace,String resource);
    public ClusterOperatorStatusFluent.RelatedObjectsNested<A> addNewRelatedObject();
    public ClusterOperatorStatusFluent.RelatedObjectsNested<A> addNewRelatedObjectLike(io.fabric8.openshift.api.model.ObjectReference item);
    public ClusterOperatorStatusFluent.RelatedObjectsNested<A> setNewRelatedObjectLike(int index,io.fabric8.openshift.api.model.ObjectReference item);
    public ClusterOperatorStatusFluent.RelatedObjectsNested<A> editRelatedObject(int index);
    public ClusterOperatorStatusFluent.RelatedObjectsNested<A> editFirstRelatedObject();
    public ClusterOperatorStatusFluent.RelatedObjectsNested<A> editLastRelatedObject();
    public ClusterOperatorStatusFluent.RelatedObjectsNested<A> editMatchingRelatedObject(Predicate<io.fabric8.openshift.api.model.ObjectReferenceBuilder> predicate);
    public A addToVersions(int index,OperandVersion item);
    public A setToVersions(int index,OperandVersion item);
    public A addToVersions(OperandVersion... items);
    public A addAllToVersions(Collection<OperandVersion> items);
    public A removeFromVersions(OperandVersion... items);
    public A removeAllFromVersions(Collection<OperandVersion> items);
    public A removeMatchingFromVersions(Predicate<OperandVersionBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildVersions instead.
 * @return The buildable object.
 */
@Deprecated public List<OperandVersion> getVersions();
    public List<OperandVersion> buildVersions();
    public OperandVersion buildVersion(int index);
    public OperandVersion buildFirstVersion();
    public OperandVersion buildLastVersion();
    public OperandVersion buildMatchingVersion(Predicate<OperandVersionBuilder> predicate);
    public Boolean hasMatchingVersion(Predicate<OperandVersionBuilder> predicate);
    public A withVersions(List<OperandVersion> versions);
    public A withVersions(OperandVersion... versions);
    public Boolean hasVersions();
    public A addNewVersion(String name,String version);
    public ClusterOperatorStatusFluent.VersionsNested<A> addNewVersion();
    public ClusterOperatorStatusFluent.VersionsNested<A> addNewVersionLike(OperandVersion item);
    public ClusterOperatorStatusFluent.VersionsNested<A> setNewVersionLike(int index,OperandVersion item);
    public ClusterOperatorStatusFluent.VersionsNested<A> editVersion(int index);
    public ClusterOperatorStatusFluent.VersionsNested<A> editFirstVersion();
    public ClusterOperatorStatusFluent.VersionsNested<A> editLastVersion();
    public ClusterOperatorStatusFluent.VersionsNested<A> editMatchingVersion(Predicate<OperandVersionBuilder> predicate);
    public interface ConditionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ClusterOperatorStatusConditionFluent<ClusterOperatorStatusFluent.ConditionsNested<N>> {

        public N and();
        public N endCondition();    }


    public interface ClusterVersionExtensionNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ClusterVersionFluent<ClusterOperatorStatusFluent.ClusterVersionExtensionNested<N>> {

        public N and();
        public N endClusterVersionExtension();    }


    public interface ImageStreamImportExtensionNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ImageStreamImportFluent<ClusterOperatorStatusFluent.ImageStreamImportExtensionNested<N>> {

        public N and();
        public N endImageStreamImportExtension();    }


    public interface ProxyExtensionNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ProxyFluent<ClusterOperatorStatusFluent.ProxyExtensionNested<N>> {

        public N and();
        public N endProxyExtension();    }


    public interface ProjectExtensionNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ProjectFluent<ClusterOperatorStatusFluent.ProjectExtensionNested<N>> {

        public N and();
        public N endProjectExtension();    }


    public interface ClusterOperatorExtensionNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ClusterOperatorFluent<ClusterOperatorStatusFluent.ClusterOperatorExtensionNested<N>> {

        public N and();
        public N endClusterOperatorExtension();    }


    public interface BuildConfigExtensionNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,BuildConfigFluent<ClusterOperatorStatusFluent.BuildConfigExtensionNested<N>> {

        public N and();
        public N endBuildConfigExtension();    }


    public interface InfrastructureExtensionNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,InfrastructureFluent<ClusterOperatorStatusFluent.InfrastructureExtensionNested<N>> {

        public N and();
        public N endInfrastructureExtension();    }


    public interface SchedulerExtensionNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,SchedulerFluent<ClusterOperatorStatusFluent.SchedulerExtensionNested<N>> {

        public N and();
        public N endSchedulerExtension();    }


    public interface RangeAllocationExtensionNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,RangeAllocationFluent<ClusterOperatorStatusFluent.RangeAllocationExtensionNested<N>> {

        public N and();
        public N endRangeAllocationExtension();    }


    public interface RouteExtensionNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,RouteFluent<ClusterOperatorStatusFluent.RouteExtensionNested<N>> {

        public N and();
        public N endRouteExtension();    }


    public interface ClusterNetworkExtensionNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ClusterNetworkFluent<ClusterOperatorStatusFluent.ClusterNetworkExtensionNested<N>> {

        public N and();
        public N endClusterNetworkExtension();    }


    public interface OAuthAuthorizeTokenExtensionNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,OAuthAuthorizeTokenFluent<ClusterOperatorStatusFluent.OAuthAuthorizeTokenExtensionNested<N>> {

        public N and();
        public N endOAuthAuthorizeTokenExtension();    }


    public interface OAuthExtensionNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,OAuthFluent<ClusterOperatorStatusFluent.OAuthExtensionNested<N>> {

        public N and();
        public N endOAuthExtension();    }


    public interface OperatorHubExtensionNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,OperatorHubFluent<ClusterOperatorStatusFluent.OperatorHubExtensionNested<N>> {

        public N and();
        public N endOperatorHubExtension();    }


    public interface ClusterRoleBindingExtensionNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ClusterRoleBindingFluent<ClusterOperatorStatusFluent.ClusterRoleBindingExtensionNested<N>> {

        public N and();
        public N endClusterRoleBindingExtension();    }


    public interface ClusterResourceQuotaExtensionNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ClusterResourceQuotaFluent<ClusterOperatorStatusFluent.ClusterResourceQuotaExtensionNested<N>> {

        public N and();
        public N endClusterResourceQuotaExtension();    }


    public interface ProjectRequestExtensionNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ProjectRequestFluent<ClusterOperatorStatusFluent.ProjectRequestExtensionNested<N>> {

        public N and();
        public N endProjectRequestExtension();    }


    public interface TemplateExtensionNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,TemplateFluent<ClusterOperatorStatusFluent.TemplateExtensionNested<N>> {

        public N and();
        public N endTemplateExtension();    }


    public interface OAuthClientAuthorizationExtensionNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,OAuthClientAuthorizationFluent<ClusterOperatorStatusFluent.OAuthClientAuthorizationExtensionNested<N>> {

        public N and();
        public N endOAuthClientAuthorizationExtension();    }


    public interface ClusterRoleExtensionNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ClusterRoleFluent<ClusterOperatorStatusFluent.ClusterRoleExtensionNested<N>> {

        public N and();
        public N endClusterRoleExtension();    }


    public interface ImageTagExtensionNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ImageTagFluent<ClusterOperatorStatusFluent.ImageTagExtensionNested<N>> {

        public N and();
        public N endImageTagExtension();    }


    public interface DeploymentConfigExtensionNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,DeploymentConfigFluent<ClusterOperatorStatusFluent.DeploymentConfigExtensionNested<N>> {

        public N and();
        public N endDeploymentConfigExtension();    }


    public interface OAuthAccessTokenExtensionNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,OAuthAccessTokenFluent<ClusterOperatorStatusFluent.OAuthAccessTokenExtensionNested<N>> {

        public N and();
        public N endOAuthAccessTokenExtension();    }


    public interface RoleBindingExtensionNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,RoleBindingFluent<ClusterOperatorStatusFluent.RoleBindingExtensionNested<N>> {

        public N and();
        public N endRoleBindingExtension();    }


    public interface ImageExtensionNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ImageFluent<ClusterOperatorStatusFluent.ImageExtensionNested<N>> {

        public N and();
        public N endImageExtension();    }


    public interface APIServerExtensionNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,APIServerFluent<ClusterOperatorStatusFluent.APIServerExtensionNested<N>> {

        public N and();
        public N endAPIServerExtension();    }


    public interface PersistentVolumeClaimExtensionNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PersistentVolumeClaimFluent<ClusterOperatorStatusFluent.PersistentVolumeClaimExtensionNested<N>> {

        public N and();
        public N endPersistentVolumeClaimExtension();    }


    public interface ImageStreamMappingExtensionNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ImageStreamMappingFluent<ClusterOperatorStatusFluent.ImageStreamMappingExtensionNested<N>> {

        public N and();
        public N endImageStreamMappingExtension();    }


    public interface RoleExtensionNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,RoleFluent<ClusterOperatorStatusFluent.RoleExtensionNested<N>> {

        public N and();
        public N endRoleExtension();    }


    public interface FeatureGateExtensionNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,FeatureGateFluent<ClusterOperatorStatusFluent.FeatureGateExtensionNested<N>> {

        public N and();
        public N endFeatureGateExtension();    }


    public interface UserExtensionNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,UserFluent<ClusterOperatorStatusFluent.UserExtensionNested<N>> {

        public N and();
        public N endUserExtension();    }


    public interface ImageStreamImageExtensionNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ImageStreamImageFluent<ClusterOperatorStatusFluent.ImageStreamImageExtensionNested<N>> {

        public N and();
        public N endImageStreamImageExtension();    }


    public interface BuildExtensionNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,BuildFluent<ClusterOperatorStatusFluent.BuildExtensionNested<N>> {

        public N and();
        public N endBuildExtension();    }


    public interface RoleBindingRestrictionExtensionNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,RoleBindingRestrictionFluent<ClusterOperatorStatusFluent.RoleBindingRestrictionExtensionNested<N>> {

        public N and();
        public N endRoleBindingRestrictionExtension();    }


    public interface ImageStreamTagExtensionNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ImageStreamTagFluent<ClusterOperatorStatusFluent.ImageStreamTagExtensionNested<N>> {

        public N and();
        public N endImageStreamTagExtension();    }


    public interface GroupExtensionNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,GroupFluent<ClusterOperatorStatusFluent.GroupExtensionNested<N>> {

        public N and();
        public N endGroupExtension();    }


    public interface ImageSignatureExtensionNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ImageSignatureFluent<ClusterOperatorStatusFluent.ImageSignatureExtensionNested<N>> {

        public N and();
        public N endImageSignatureExtension();    }


    public interface AppliedClusterResourceQuotaExtensionNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,AppliedClusterResourceQuotaFluent<ClusterOperatorStatusFluent.AppliedClusterResourceQuotaExtensionNested<N>> {

        public N and();
        public N endAppliedClusterResourceQuotaExtension();    }


    public interface SecurityContextConstraintsExtensionNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,SecurityContextConstraintsFluent<ClusterOperatorStatusFluent.SecurityContextConstraintsExtensionNested<N>> {

        public N and();
        public N endSecurityContextConstraintsExtension();    }


    public interface BuildRequestExtensionNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,BuildRequestFluent<ClusterOperatorStatusFluent.BuildRequestExtensionNested<N>> {

        public N and();
        public N endBuildRequestExtension();    }


    public interface EgressNetworkPolicyExtensionNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,EgressNetworkPolicyFluent<ClusterOperatorStatusFluent.EgressNetworkPolicyExtensionNested<N>> {

        public N and();
        public N endEgressNetworkPolicyExtension();    }


    public interface NetNamespaceExtensionNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,NetNamespaceFluent<ClusterOperatorStatusFluent.NetNamespaceExtensionNested<N>> {

        public N and();
        public N endNetNamespaceExtension();    }


    public interface ImageStreamExtensionNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ImageStreamFluent<ClusterOperatorStatusFluent.ImageStreamExtensionNested<N>> {

        public N and();
        public N endImageStreamExtension();    }


    public interface OAuthClientExtensionNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,OAuthClientFluent<ClusterOperatorStatusFluent.OAuthClientExtensionNested<N>> {

        public N and();
        public N endOAuthClientExtension();    }


    public interface IdentityExtensionNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,IdentityFluent<ClusterOperatorStatusFluent.IdentityExtensionNested<N>> {

        public N and();
        public N endIdentityExtension();    }


    public interface RelatedObjectsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.openshift.api.model.ObjectReferenceFluent<ClusterOperatorStatusFluent.RelatedObjectsNested<N>> {

        public N and();
        public N endRelatedObject();    }


    public interface VersionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,OperandVersionFluent<ClusterOperatorStatusFluent.VersionsNested<N>> {

        public N and();
        public N endVersion();    }


}
