package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ResourceQuotaSpec;
import java.lang.String;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public interface ClusterResourceQuotaSpecFluent<A extends ClusterResourceQuotaSpecFluent<A>> extends Fluent<A> {


    public ResourceQuotaSpec getQuota();
    public A withQuota(ResourceQuotaSpec quota);
    public Boolean hasQuota();
    
/**
 * This method has been deprecated, please use method buildSelector instead.
 * @return The buildable object.
 */
@Deprecated public ClusterResourceQuotaSelector getSelector();
    public ClusterResourceQuotaSelector buildSelector();
    public A withSelector(ClusterResourceQuotaSelector selector);
    public Boolean hasSelector();
    public ClusterResourceQuotaSpecFluent.SelectorNested<A> withNewSelector();
    public ClusterResourceQuotaSpecFluent.SelectorNested<A> withNewSelectorLike(ClusterResourceQuotaSelector item);
    public ClusterResourceQuotaSpecFluent.SelectorNested<A> editSelector();
    public ClusterResourceQuotaSpecFluent.SelectorNested<A> editOrNewSelector();
    public ClusterResourceQuotaSpecFluent.SelectorNested<A> editOrNewSelectorLike(ClusterResourceQuotaSelector item);
    public interface SelectorNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ClusterResourceQuotaSelectorFluent<ClusterResourceQuotaSpecFluent.SelectorNested<N>> {

        public N and();
        public N endSelector();    }


}
