package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public interface InfrastructureFluent<A extends InfrastructureFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public InfrastructureFluent.MetadataNested<A> withNewMetadata();
    public InfrastructureFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public InfrastructureFluent.MetadataNested<A> editMetadata();
    public InfrastructureFluent.MetadataNested<A> editOrNewMetadata();
    public InfrastructureFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public InfrastructureSpec getSpec();
    public InfrastructureSpec buildSpec();
    public A withSpec(InfrastructureSpec spec);
    public Boolean hasSpec();
    public InfrastructureFluent.SpecNested<A> withNewSpec();
    public InfrastructureFluent.SpecNested<A> withNewSpecLike(InfrastructureSpec item);
    public InfrastructureFluent.SpecNested<A> editSpec();
    public InfrastructureFluent.SpecNested<A> editOrNewSpec();
    public InfrastructureFluent.SpecNested<A> editOrNewSpecLike(InfrastructureSpec item);
    
/**
 * This method has been deprecated, please use method buildStatus instead.
 * @return The buildable object.
 */
@Deprecated public InfrastructureStatus getStatus();
    public InfrastructureStatus buildStatus();
    public A withStatus(InfrastructureStatus status);
    public Boolean hasStatus();
    public InfrastructureFluent.StatusNested<A> withNewStatus();
    public InfrastructureFluent.StatusNested<A> withNewStatusLike(InfrastructureStatus item);
    public InfrastructureFluent.StatusNested<A> editStatus();
    public InfrastructureFluent.StatusNested<A> editOrNewStatus();
    public InfrastructureFluent.StatusNested<A> editOrNewStatusLike(InfrastructureStatus item);
    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<InfrastructureFluent.MetadataNested<N>> {

        public N and();
        public N endMetadata();    }


    public interface SpecNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,InfrastructureSpecFluent<InfrastructureFluent.SpecNested<N>> {

        public N and();
        public N endSpec();    }


    public interface StatusNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,InfrastructureStatusFluent<InfrastructureFluent.StatusNested<N>> {

        public N and();
        public N endStatus();    }


}
