package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class OpenStackPlatformSpecBuilder extends OpenStackPlatformSpecFluentImpl<OpenStackPlatformSpecBuilder> implements VisitableBuilder<OpenStackPlatformSpec,OpenStackPlatformSpecBuilder> {

    OpenStackPlatformSpecFluent<?> fluent;
    Boolean validationEnabled;

    public OpenStackPlatformSpecBuilder() { 
        this(true);
    }


    public OpenStackPlatformSpecBuilder(Boolean validationEnabled) { 
        this(new OpenStackPlatformSpec(), validationEnabled);
    }


    public OpenStackPlatformSpecBuilder(OpenStackPlatformSpecFluent<?> fluent) { 
        this(fluent, true);
    }


    public OpenStackPlatformSpecBuilder(OpenStackPlatformSpecFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new OpenStackPlatformSpec(), validationEnabled);
    }


    public OpenStackPlatformSpecBuilder(OpenStackPlatformSpecFluent<?> fluent,OpenStackPlatformSpec instance) { 
        this(fluent, instance, true);
    }


    public OpenStackPlatformSpecBuilder(OpenStackPlatformSpecFluent<?> fluent,OpenStackPlatformSpec instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        this.validationEnabled = validationEnabled; 
    }


    public OpenStackPlatformSpecBuilder(OpenStackPlatformSpec instance) { 
        this(instance,true);
    }


    public OpenStackPlatformSpecBuilder(OpenStackPlatformSpec instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.validationEnabled = validationEnabled; 
    }


    public OpenStackPlatformSpec build() {
        OpenStackPlatformSpec buildable = new OpenStackPlatformSpec();
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        OpenStackPlatformSpecBuilder that = (OpenStackPlatformSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
