package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface PodSecurityPolicyReviewStatusFluent<A extends PodSecurityPolicyReviewStatusFluent<A>> extends Fluent<A> {


    public A addToAllowedServiceAccounts(int index,ServiceAccountPodSecurityPolicyReviewStatus item);
    public A setToAllowedServiceAccounts(int index,ServiceAccountPodSecurityPolicyReviewStatus item);
    public A addToAllowedServiceAccounts(ServiceAccountPodSecurityPolicyReviewStatus... items);
    public A addAllToAllowedServiceAccounts(Collection<ServiceAccountPodSecurityPolicyReviewStatus> items);
    public A removeFromAllowedServiceAccounts(ServiceAccountPodSecurityPolicyReviewStatus... items);
    public A removeAllFromAllowedServiceAccounts(Collection<ServiceAccountPodSecurityPolicyReviewStatus> items);
    public A removeMatchingFromAllowedServiceAccounts(Predicate<ServiceAccountPodSecurityPolicyReviewStatusBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildAllowedServiceAccounts instead.
 * @return The buildable object.
 */
@Deprecated public List<ServiceAccountPodSecurityPolicyReviewStatus> getAllowedServiceAccounts();
    public List<ServiceAccountPodSecurityPolicyReviewStatus> buildAllowedServiceAccounts();
    public ServiceAccountPodSecurityPolicyReviewStatus buildAllowedServiceAccount(int index);
    public ServiceAccountPodSecurityPolicyReviewStatus buildFirstAllowedServiceAccount();
    public ServiceAccountPodSecurityPolicyReviewStatus buildLastAllowedServiceAccount();
    public ServiceAccountPodSecurityPolicyReviewStatus buildMatchingAllowedServiceAccount(Predicate<ServiceAccountPodSecurityPolicyReviewStatusBuilder> predicate);
    public Boolean hasMatchingAllowedServiceAccount(Predicate<ServiceAccountPodSecurityPolicyReviewStatusBuilder> predicate);
    public A withAllowedServiceAccounts(List<ServiceAccountPodSecurityPolicyReviewStatus> allowedServiceAccounts);
    public A withAllowedServiceAccounts(ServiceAccountPodSecurityPolicyReviewStatus... allowedServiceAccounts);
    public Boolean hasAllowedServiceAccounts();
    public PodSecurityPolicyReviewStatusFluent.AllowedServiceAccountsNested<A> addNewAllowedServiceAccount();
    public PodSecurityPolicyReviewStatusFluent.AllowedServiceAccountsNested<A> addNewAllowedServiceAccountLike(ServiceAccountPodSecurityPolicyReviewStatus item);
    public PodSecurityPolicyReviewStatusFluent.AllowedServiceAccountsNested<A> setNewAllowedServiceAccountLike(int index,ServiceAccountPodSecurityPolicyReviewStatus item);
    public PodSecurityPolicyReviewStatusFluent.AllowedServiceAccountsNested<A> editAllowedServiceAccount(int index);
    public PodSecurityPolicyReviewStatusFluent.AllowedServiceAccountsNested<A> editFirstAllowedServiceAccount();
    public PodSecurityPolicyReviewStatusFluent.AllowedServiceAccountsNested<A> editLastAllowedServiceAccount();
    public PodSecurityPolicyReviewStatusFluent.AllowedServiceAccountsNested<A> editMatchingAllowedServiceAccount(Predicate<ServiceAccountPodSecurityPolicyReviewStatusBuilder> predicate);
    public interface AllowedServiceAccountsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ServiceAccountPodSecurityPolicyReviewStatusFluent<PodSecurityPolicyReviewStatusFluent.AllowedServiceAccountsNested<N>> {

        public N and();
        public N endAllowedServiceAccount();    }


}
