package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface SchedulerListFluent<A extends SchedulerListFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToItems(int index,Scheduler item);
    public A setToItems(int index,Scheduler item);
    public A addToItems(Scheduler... items);
    public A addAllToItems(Collection<Scheduler> items);
    public A removeFromItems(Scheduler... items);
    public A removeAllFromItems(Collection<Scheduler> items);
    public A removeMatchingFromItems(Predicate<SchedulerBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<Scheduler> getItems();
    public List<Scheduler> buildItems();
    public Scheduler buildItem(int index);
    public Scheduler buildFirstItem();
    public Scheduler buildLastItem();
    public Scheduler buildMatchingItem(Predicate<SchedulerBuilder> predicate);
    public Boolean hasMatchingItem(Predicate<SchedulerBuilder> predicate);
    public A withItems(List<Scheduler> items);
    public A withItems(Scheduler... items);
    public Boolean hasItems();
    public SchedulerListFluent.ItemsNested<A> addNewItem();
    public SchedulerListFluent.ItemsNested<A> addNewItemLike(Scheduler item);
    public SchedulerListFluent.ItemsNested<A> setNewItemLike(int index,Scheduler item);
    public SchedulerListFluent.ItemsNested<A> editItem(int index);
    public SchedulerListFluent.ItemsNested<A> editFirstItem();
    public SchedulerListFluent.ItemsNested<A> editLastItem();
    public SchedulerListFluent.ItemsNested<A> editMatchingItem(Predicate<SchedulerBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);
    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,SchedulerFluent<SchedulerListFluent.ItemsNested<N>> {

        public N and();
        public N endItem();    }


}
