package io.fabric8.openshift.api.model;

import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class UpdateHistoryFluentImpl<A extends UpdateHistoryFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements UpdateHistoryFluent<A> {

    private String completionTime;
    private String image;
    private String startedTime;
    private String state;
    private Boolean verified;
    private String version;

    public UpdateHistoryFluentImpl() { 
    }


    public UpdateHistoryFluentImpl(UpdateHistory instance) { 
        this.withCompletionTime(instance.getCompletionTime()); 
        this.withImage(instance.getImage()); 
        this.withStartedTime(instance.getStartedTime()); 
        this.withState(instance.getState()); 
        this.withVerified(instance.getVerified()); 
        this.withVersion(instance.getVersion()); 
    }


    public String getCompletionTime() {
        return this.completionTime;
    }

    public A withCompletionTime(String completionTime) {
        this.completionTime=completionTime; return (A) this;
    }

    public Boolean hasCompletionTime() {
        return this.completionTime != null;
    }

    public A withNewCompletionTime(String arg1) {
        return (A)withCompletionTime(new String(arg1));
    }

    public A withNewCompletionTime(StringBuilder arg1) {
        return (A)withCompletionTime(new String(arg1));
    }

    public A withNewCompletionTime(StringBuffer arg1) {
        return (A)withCompletionTime(new String(arg1));
    }

    public String getImage() {
        return this.image;
    }

    public A withImage(String image) {
        this.image=image; return (A) this;
    }

    public Boolean hasImage() {
        return this.image != null;
    }

    public A withNewImage(String arg1) {
        return (A)withImage(new String(arg1));
    }

    public A withNewImage(StringBuilder arg1) {
        return (A)withImage(new String(arg1));
    }

    public A withNewImage(StringBuffer arg1) {
        return (A)withImage(new String(arg1));
    }

    public String getStartedTime() {
        return this.startedTime;
    }

    public A withStartedTime(String startedTime) {
        this.startedTime=startedTime; return (A) this;
    }

    public Boolean hasStartedTime() {
        return this.startedTime != null;
    }

    public A withNewStartedTime(String arg1) {
        return (A)withStartedTime(new String(arg1));
    }

    public A withNewStartedTime(StringBuilder arg1) {
        return (A)withStartedTime(new String(arg1));
    }

    public A withNewStartedTime(StringBuffer arg1) {
        return (A)withStartedTime(new String(arg1));
    }

    public String getState() {
        return this.state;
    }

    public A withState(String state) {
        this.state=state; return (A) this;
    }

    public Boolean hasState() {
        return this.state != null;
    }

    public A withNewState(String arg1) {
        return (A)withState(new String(arg1));
    }

    public A withNewState(StringBuilder arg1) {
        return (A)withState(new String(arg1));
    }

    public A withNewState(StringBuffer arg1) {
        return (A)withState(new String(arg1));
    }

    public Boolean isVerified() {
        return this.verified;
    }

    public A withVerified(Boolean verified) {
        this.verified=verified; return (A) this;
    }

    public Boolean hasVerified() {
        return this.verified != null;
    }

    public A withNewVerified(String arg1) {
        return (A)withVerified(new Boolean(arg1));
    }

    public A withNewVerified(boolean arg1) {
        return (A)withVerified(new Boolean(arg1));
    }

    public String getVersion() {
        return this.version;
    }

    public A withVersion(String version) {
        this.version=version; return (A) this;
    }

    public Boolean hasVersion() {
        return this.version != null;
    }

    public A withNewVersion(String arg1) {
        return (A)withVersion(new String(arg1));
    }

    public A withNewVersion(StringBuilder arg1) {
        return (A)withVersion(new String(arg1));
    }

    public A withNewVersion(StringBuffer arg1) {
        return (A)withVersion(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        UpdateHistoryFluentImpl that = (UpdateHistoryFluentImpl) o;
        if (completionTime != null ? !completionTime.equals(that.completionTime) :that.completionTime != null) return false;
        if (image != null ? !image.equals(that.image) :that.image != null) return false;
        if (startedTime != null ? !startedTime.equals(that.startedTime) :that.startedTime != null) return false;
        if (state != null ? !state.equals(that.state) :that.state != null) return false;
        if (verified != null ? !verified.equals(that.verified) :that.verified != null) return false;
        if (version != null ? !version.equals(that.version) :that.version != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(completionTime,  image,  startedTime,  state,  verified,  version,  super.hashCode());
    }

}
