package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface APIServerNamedServingCertFluent<A extends APIServerNamedServingCertFluent<A>> extends Fluent<A> {


    public A addToNames(int index,String item);
    public A setToNames(int index,String item);
    public A addToNames(String... items);
    public A addAllToNames(Collection<String> items);
    public A removeFromNames(String... items);
    public A removeAllFromNames(Collection<String> items);
    public List<String> getNames();
    public String getName(int index);
    public String getFirstName();
    public String getLastName();
    public String getMatchingName(Predicate<String> predicate);
    public Boolean hasMatchingName(Predicate<String> predicate);
    public A withNames(List<String> names);
    public A withNames(String... names);
    public Boolean hasNames();
    public A addNewName(String arg1);
    public A addNewName(StringBuilder arg1);
    public A addNewName(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildServingCertificate instead.
 * @return The buildable object.
 */
@Deprecated public SecretNameReference getServingCertificate();
    public SecretNameReference buildServingCertificate();
    public A withServingCertificate(SecretNameReference servingCertificate);
    public Boolean hasServingCertificate();
    public A withNewServingCertificate(String name);
    public APIServerNamedServingCertFluent.ServingCertificateNested<A> withNewServingCertificate();
    public APIServerNamedServingCertFluent.ServingCertificateNested<A> withNewServingCertificateLike(SecretNameReference item);
    public APIServerNamedServingCertFluent.ServingCertificateNested<A> editServingCertificate();
    public APIServerNamedServingCertFluent.ServingCertificateNested<A> editOrNewServingCertificate();
    public APIServerNamedServingCertFluent.ServingCertificateNested<A> editOrNewServingCertificateLike(SecretNameReference item);
    public interface ServingCertificateNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,SecretNameReferenceFluent<APIServerNamedServingCertFluent.ServingCertificateNested<N>> {

        public N and();
        public N endServingCertificate();    }


}
