package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class BasicAuthIdentityProviderBuilder extends BasicAuthIdentityProviderFluentImpl<BasicAuthIdentityProviderBuilder> implements VisitableBuilder<BasicAuthIdentityProvider,BasicAuthIdentityProviderBuilder> {

    BasicAuthIdentityProviderFluent<?> fluent;
    Boolean validationEnabled;

    public BasicAuthIdentityProviderBuilder() { 
        this(true);
    }


    public BasicAuthIdentityProviderBuilder(Boolean validationEnabled) { 
        this(new BasicAuthIdentityProvider(), validationEnabled);
    }


    public BasicAuthIdentityProviderBuilder(BasicAuthIdentityProviderFluent<?> fluent) { 
        this(fluent, true);
    }


    public BasicAuthIdentityProviderBuilder(BasicAuthIdentityProviderFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new BasicAuthIdentityProvider(), validationEnabled);
    }


    public BasicAuthIdentityProviderBuilder(BasicAuthIdentityProviderFluent<?> fluent,BasicAuthIdentityProvider instance) { 
        this(fluent, instance, true);
    }


    public BasicAuthIdentityProviderBuilder(BasicAuthIdentityProviderFluent<?> fluent,BasicAuthIdentityProvider instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withCa(instance.getCa()); 
        fluent.withTlsClientCert(instance.getTlsClientCert()); 
        fluent.withTlsClientKey(instance.getTlsClientKey()); 
        fluent.withUrl(instance.getUrl()); 
        this.validationEnabled = validationEnabled; 
    }


    public BasicAuthIdentityProviderBuilder(BasicAuthIdentityProvider instance) { 
        this(instance,true);
    }


    public BasicAuthIdentityProviderBuilder(BasicAuthIdentityProvider instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withCa(instance.getCa()); 
        this.withTlsClientCert(instance.getTlsClientCert()); 
        this.withTlsClientKey(instance.getTlsClientKey()); 
        this.withUrl(instance.getUrl()); 
        this.validationEnabled = validationEnabled; 
    }


    public BasicAuthIdentityProvider build() {
        BasicAuthIdentityProvider buildable = new BasicAuthIdentityProvider(fluent.getCa(),fluent.getTlsClientCert(),fluent.getTlsClientKey(),fluent.getUrl());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        BasicAuthIdentityProviderBuilder that = (BasicAuthIdentityProviderBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
