package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class PodSecurityPolicySelfSubjectReviewFluentImpl<A extends PodSecurityPolicySelfSubjectReviewFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements PodSecurityPolicySelfSubjectReviewFluent<A> {

    private String apiVersion;
    private String kind;
    private PodSecurityPolicySelfSubjectReviewSpecBuilder spec;
    private PodSecurityPolicySubjectReviewStatusBuilder status;

    public PodSecurityPolicySelfSubjectReviewFluentImpl() { 
    }


    public PodSecurityPolicySelfSubjectReviewFluentImpl(PodSecurityPolicySelfSubjectReview instance) { 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withSpec(instance.getSpec()); 
        this.withStatus(instance.getStatus()); 
    }


    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public A withNewApiVersion(String arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuilder arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuffer arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind=kind; return (A) this;
    }

    public Boolean hasKind() {
        return this.kind != null;
    }

    public A withNewKind(String arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuilder arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuffer arg1) {
        return (A)withKind(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public PodSecurityPolicySelfSubjectReviewSpec getSpec() {
        return this.spec!=null?this.spec.build():null;
    }

    public PodSecurityPolicySelfSubjectReviewSpec buildSpec() {
        return this.spec!=null?this.spec.build():null;
    }

    public A withSpec(PodSecurityPolicySelfSubjectReviewSpec spec) {
        _visitables.get("spec").remove(this.spec);
        if (spec!=null){ this.spec= new PodSecurityPolicySelfSubjectReviewSpecBuilder(spec); _visitables.get("spec").add(this.spec);} return (A) this;
    }

    public Boolean hasSpec() {
        return this.spec != null;
    }

    public PodSecurityPolicySelfSubjectReviewFluent.SpecNested<A> withNewSpec() {
        return new SpecNestedImpl();
    }

    public PodSecurityPolicySelfSubjectReviewFluent.SpecNested<A> withNewSpecLike(PodSecurityPolicySelfSubjectReviewSpec item) {
        return new SpecNestedImpl(item);
    }

    public PodSecurityPolicySelfSubjectReviewFluent.SpecNested<A> editSpec() {
        return withNewSpecLike(getSpec());
    }

    public PodSecurityPolicySelfSubjectReviewFluent.SpecNested<A> editOrNewSpec() {
        return withNewSpecLike(getSpec() != null ? getSpec(): new PodSecurityPolicySelfSubjectReviewSpecBuilder().build());
    }

    public PodSecurityPolicySelfSubjectReviewFluent.SpecNested<A> editOrNewSpecLike(PodSecurityPolicySelfSubjectReviewSpec item) {
        return withNewSpecLike(getSpec() != null ? getSpec(): item);
    }

    
/**
 * This method has been deprecated, please use method buildStatus instead.
 * @return The buildable object.
 */
@Deprecated public PodSecurityPolicySubjectReviewStatus getStatus() {
        return this.status!=null?this.status.build():null;
    }

    public PodSecurityPolicySubjectReviewStatus buildStatus() {
        return this.status!=null?this.status.build():null;
    }

    public A withStatus(PodSecurityPolicySubjectReviewStatus status) {
        _visitables.get("status").remove(this.status);
        if (status!=null){ this.status= new PodSecurityPolicySubjectReviewStatusBuilder(status); _visitables.get("status").add(this.status);} return (A) this;
    }

    public Boolean hasStatus() {
        return this.status != null;
    }

    public PodSecurityPolicySelfSubjectReviewFluent.StatusNested<A> withNewStatus() {
        return new StatusNestedImpl();
    }

    public PodSecurityPolicySelfSubjectReviewFluent.StatusNested<A> withNewStatusLike(PodSecurityPolicySubjectReviewStatus item) {
        return new StatusNestedImpl(item);
    }

    public PodSecurityPolicySelfSubjectReviewFluent.StatusNested<A> editStatus() {
        return withNewStatusLike(getStatus());
    }

    public PodSecurityPolicySelfSubjectReviewFluent.StatusNested<A> editOrNewStatus() {
        return withNewStatusLike(getStatus() != null ? getStatus(): new PodSecurityPolicySubjectReviewStatusBuilder().build());
    }

    public PodSecurityPolicySelfSubjectReviewFluent.StatusNested<A> editOrNewStatusLike(PodSecurityPolicySubjectReviewStatus item) {
        return withNewStatusLike(getStatus() != null ? getStatus(): item);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PodSecurityPolicySelfSubjectReviewFluentImpl that = (PodSecurityPolicySelfSubjectReviewFluentImpl) o;
        if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
        if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
        if (spec != null ? !spec.equals(that.spec) :that.spec != null) return false;
        if (status != null ? !status.equals(that.status) :that.status != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(apiVersion,  kind,  spec,  status,  super.hashCode());
    }

    public class SpecNestedImpl<N> extends PodSecurityPolicySelfSubjectReviewSpecFluentImpl<PodSecurityPolicySelfSubjectReviewFluent.SpecNested<N>> implements PodSecurityPolicySelfSubjectReviewFluent.SpecNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final PodSecurityPolicySelfSubjectReviewSpecBuilder builder;

        SpecNestedImpl(PodSecurityPolicySelfSubjectReviewSpec item) {
            this.builder = new PodSecurityPolicySelfSubjectReviewSpecBuilder(this, item);
        }

        SpecNestedImpl() {
            this.builder = new PodSecurityPolicySelfSubjectReviewSpecBuilder(this);
        }

        public N and() {
             return (N) PodSecurityPolicySelfSubjectReviewFluentImpl.this.withSpec(builder.build());
        }

        public N endSpec() {
             return and();
        }
    }


    public class StatusNestedImpl<N> extends PodSecurityPolicySubjectReviewStatusFluentImpl<PodSecurityPolicySelfSubjectReviewFluent.StatusNested<N>> implements PodSecurityPolicySelfSubjectReviewFluent.StatusNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final PodSecurityPolicySubjectReviewStatusBuilder builder;

        StatusNestedImpl(PodSecurityPolicySubjectReviewStatus item) {
            this.builder = new PodSecurityPolicySubjectReviewStatusBuilder(this, item);
        }

        StatusNestedImpl() {
            this.builder = new PodSecurityPolicySubjectReviewStatusBuilder(this);
        }

        public N and() {
             return (N) PodSecurityPolicySelfSubjectReviewFluentImpl.this.withStatus(builder.build());
        }

        public N endStatus() {
             return and();
        }
    }


}
