package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface ProxyListFluent<A extends ProxyListFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToItems(int index,Proxy item);
    public A setToItems(int index,Proxy item);
    public A addToItems(Proxy... items);
    public A addAllToItems(Collection<Proxy> items);
    public A removeFromItems(Proxy... items);
    public A removeAllFromItems(Collection<Proxy> items);
    public A removeMatchingFromItems(Predicate<ProxyBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<Proxy> getItems();
    public List<Proxy> buildItems();
    public Proxy buildItem(int index);
    public Proxy buildFirstItem();
    public Proxy buildLastItem();
    public Proxy buildMatchingItem(Predicate<ProxyBuilder> predicate);
    public Boolean hasMatchingItem(Predicate<ProxyBuilder> predicate);
    public A withItems(List<Proxy> items);
    public A withItems(Proxy... items);
    public Boolean hasItems();
    public ProxyListFluent.ItemsNested<A> addNewItem();
    public ProxyListFluent.ItemsNested<A> addNewItemLike(Proxy item);
    public ProxyListFluent.ItemsNested<A> setNewItemLike(int index,Proxy item);
    public ProxyListFluent.ItemsNested<A> editItem(int index);
    public ProxyListFluent.ItemsNested<A> editFirstItem();
    public ProxyListFluent.ItemsNested<A> editLastItem();
    public ProxyListFluent.ItemsNested<A> editMatchingItem(Predicate<ProxyBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);
    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ProxyFluent<ProxyListFluent.ItemsNested<N>> {

        public N and();
        public N endItem();    }


}
