package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface EgressNetworkPolicySpecFluent<A extends EgressNetworkPolicySpecFluent<A>> extends Fluent<A> {


    public A addToEgress(int index,EgressNetworkPolicyRule item);
    public A setToEgress(int index,EgressNetworkPolicyRule item);
    public A addToEgress(EgressNetworkPolicyRule... items);
    public A addAllToEgress(Collection<EgressNetworkPolicyRule> items);
    public A removeFromEgress(EgressNetworkPolicyRule... items);
    public A removeAllFromEgress(Collection<EgressNetworkPolicyRule> items);
    public A removeMatchingFromEgress(Predicate<EgressNetworkPolicyRuleBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildEgress instead.
 * @return The buildable object.
 */
@Deprecated public List<EgressNetworkPolicyRule> getEgress();
    public List<EgressNetworkPolicyRule> buildEgress();
    public EgressNetworkPolicyRule buildEgress(int index);
    public EgressNetworkPolicyRule buildFirstEgress();
    public EgressNetworkPolicyRule buildLastEgress();
    public EgressNetworkPolicyRule buildMatchingEgress(Predicate<EgressNetworkPolicyRuleBuilder> predicate);
    public Boolean hasMatchingEgress(Predicate<EgressNetworkPolicyRuleBuilder> predicate);
    public A withEgress(List<EgressNetworkPolicyRule> egress);
    public A withEgress(EgressNetworkPolicyRule... egress);
    public Boolean hasEgress();
    public EgressNetworkPolicySpecFluent.EgressNested<A> addNewEgress();
    public EgressNetworkPolicySpecFluent.EgressNested<A> addNewEgressLike(EgressNetworkPolicyRule item);
    public EgressNetworkPolicySpecFluent.EgressNested<A> setNewEgressLike(int index,EgressNetworkPolicyRule item);
    public EgressNetworkPolicySpecFluent.EgressNested<A> editEgress(int index);
    public EgressNetworkPolicySpecFluent.EgressNested<A> editFirstEgress();
    public EgressNetworkPolicySpecFluent.EgressNested<A> editLastEgress();
    public EgressNetworkPolicySpecFluent.EgressNested<A> editMatchingEgress(Predicate<EgressNetworkPolicyRuleBuilder> predicate);
    public interface EgressNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,EgressNetworkPolicyRuleFluent<EgressNetworkPolicySpecFluent.EgressNested<N>> {

        public N and();
        public N endEgress();    }


}
