package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public interface ImageStreamImageFluent<A extends ImageStreamImageFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildImage instead.
 * @return The buildable object.
 */
@Deprecated public Image getImage();
    public Image buildImage();
    public A withImage(Image image);
    public Boolean hasImage();
    public ImageStreamImageFluent.ImageNested<A> withNewImage();
    public ImageStreamImageFluent.ImageNested<A> withNewImageLike(Image item);
    public ImageStreamImageFluent.ImageNested<A> editImage();
    public ImageStreamImageFluent.ImageNested<A> editOrNewImage();
    public ImageStreamImageFluent.ImageNested<A> editOrNewImageLike(Image item);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public ImageStreamImageFluent.MetadataNested<A> withNewMetadata();
    public ImageStreamImageFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public ImageStreamImageFluent.MetadataNested<A> editMetadata();
    public ImageStreamImageFluent.MetadataNested<A> editOrNewMetadata();
    public ImageStreamImageFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    public interface ImageNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ImageFluent<ImageStreamImageFluent.ImageNested<N>> {

        public N and();
        public N endImage();    }


    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<ImageStreamImageFluent.MetadataNested<N>> {

        public N and();
        public N endMetadata();    }


}
