package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface OAuthClientAuthorizationListFluent<A extends OAuthClientAuthorizationListFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToItems(int index,OAuthClientAuthorization item);
    public A setToItems(int index,OAuthClientAuthorization item);
    public A addToItems(OAuthClientAuthorization... items);
    public A addAllToItems(Collection<OAuthClientAuthorization> items);
    public A removeFromItems(OAuthClientAuthorization... items);
    public A removeAllFromItems(Collection<OAuthClientAuthorization> items);
    public A removeMatchingFromItems(Predicate<OAuthClientAuthorizationBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<OAuthClientAuthorization> getItems();
    public List<OAuthClientAuthorization> buildItems();
    public OAuthClientAuthorization buildItem(int index);
    public OAuthClientAuthorization buildFirstItem();
    public OAuthClientAuthorization buildLastItem();
    public OAuthClientAuthorization buildMatchingItem(Predicate<OAuthClientAuthorizationBuilder> predicate);
    public Boolean hasMatchingItem(Predicate<OAuthClientAuthorizationBuilder> predicate);
    public A withItems(List<OAuthClientAuthorization> items);
    public A withItems(OAuthClientAuthorization... items);
    public Boolean hasItems();
    public OAuthClientAuthorizationListFluent.ItemsNested<A> addNewItem();
    public OAuthClientAuthorizationListFluent.ItemsNested<A> addNewItemLike(OAuthClientAuthorization item);
    public OAuthClientAuthorizationListFluent.ItemsNested<A> setNewItemLike(int index,OAuthClientAuthorization item);
    public OAuthClientAuthorizationListFluent.ItemsNested<A> editItem(int index);
    public OAuthClientAuthorizationListFluent.ItemsNested<A> editFirstItem();
    public OAuthClientAuthorizationListFluent.ItemsNested<A> editLastItem();
    public OAuthClientAuthorizationListFluent.ItemsNested<A> editMatchingItem(Predicate<OAuthClientAuthorizationBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);
    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,OAuthClientAuthorizationFluent<OAuthClientAuthorizationListFluent.ItemsNested<N>> {

        public N and();
        public N endItem();    }


}
