package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class LDAPAttributeMappingFluentImpl<A extends LDAPAttributeMappingFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements LDAPAttributeMappingFluent<A> {

    private List<String> email = new ArrayList<String>();
    private List<String> id = new ArrayList<String>();
    private List<String> name = new ArrayList<String>();
    private List<String> preferredUsername = new ArrayList<String>();

    public LDAPAttributeMappingFluentImpl() { 
    }


    public LDAPAttributeMappingFluentImpl(LDAPAttributeMapping instance) { 
        this.withEmail(instance.getEmail()); 
        this.withId(instance.getId()); 
        this.withName(instance.getName()); 
        this.withPreferredUsername(instance.getPreferredUsername()); 
    }


    public A addToEmail(int index,String item) {
        if (this.email == null) {this.email = new ArrayList<String>();}
        this.email.add(index, item);
        return (A)this;
    }

    public A setToEmail(int index,String item) {
        if (this.email == null) {this.email = new ArrayList<String>();}
        this.email.set(index, item); return (A)this;
    }

    public A addToEmail(String... items) {
        if (this.email == null) {this.email = new ArrayList<String>();}
        for (String item : items) {this.email.add(item);} return (A)this;
    }

    public A addAllToEmail(Collection<String> items) {
        if (this.email == null) {this.email = new ArrayList<String>();}
        for (String item : items) {this.email.add(item);} return (A)this;
    }

    public A removeFromEmail(String... items) {
        for (String item : items) {if (this.email!= null){ this.email.remove(item);}} return (A)this;
    }

    public A removeAllFromEmail(Collection<String> items) {
        for (String item : items) {if (this.email!= null){ this.email.remove(item);}} return (A)this;
    }

    public List<String> getEmail() {
        return this.email;
    }

    public String getEmail(int index) {
        return this.email.get(index);
    }

    public String getFirstEmail() {
        return this.email.get(0);
    }

    public String getLastEmail() {
        return this.email.get(email.size() - 1);
    }

    public String getMatchingEmail(Predicate<String> predicate) {
        for (String item: email) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingEmail(Predicate<String> predicate) {
        for (String item: email) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withEmail(List<String> email) {
        if (this.email != null) { _visitables.get("email").removeAll(this.email);}
        if (email != null) {this.email = new ArrayList<String>(); for (String item : email){this.addToEmail(item);}} else { this.email = null;} return (A) this;
    }

    public A withEmail(String... email) {
        if (this.email != null) {this.email.clear();}
        if (email != null) {for (String item :email){ this.addToEmail(item);}} return (A) this;
    }

    public Boolean hasEmail() {
        return email != null && !email.isEmpty();
    }

    public A addNewEmail(String arg1) {
        return (A)addToEmail(new String(arg1));
    }

    public A addNewEmail(StringBuilder arg1) {
        return (A)addToEmail(new String(arg1));
    }

    public A addNewEmail(StringBuffer arg1) {
        return (A)addToEmail(new String(arg1));
    }

    public A addToId(int index,String item) {
        if (this.id == null) {this.id = new ArrayList<String>();}
        this.id.add(index, item);
        return (A)this;
    }

    public A setToId(int index,String item) {
        if (this.id == null) {this.id = new ArrayList<String>();}
        this.id.set(index, item); return (A)this;
    }

    public A addToId(String... items) {
        if (this.id == null) {this.id = new ArrayList<String>();}
        for (String item : items) {this.id.add(item);} return (A)this;
    }

    public A addAllToId(Collection<String> items) {
        if (this.id == null) {this.id = new ArrayList<String>();}
        for (String item : items) {this.id.add(item);} return (A)this;
    }

    public A removeFromId(String... items) {
        for (String item : items) {if (this.id!= null){ this.id.remove(item);}} return (A)this;
    }

    public A removeAllFromId(Collection<String> items) {
        for (String item : items) {if (this.id!= null){ this.id.remove(item);}} return (A)this;
    }

    public List<String> getId() {
        return this.id;
    }

    public String getId(int index) {
        return this.id.get(index);
    }

    public String getFirstId() {
        return this.id.get(0);
    }

    public String getLastId() {
        return this.id.get(id.size() - 1);
    }

    public String getMatchingId(Predicate<String> predicate) {
        for (String item: id) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingId(Predicate<String> predicate) {
        for (String item: id) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withId(List<String> id) {
        if (this.id != null) { _visitables.get("id").removeAll(this.id);}
        if (id != null) {this.id = new ArrayList<String>(); for (String item : id){this.addToId(item);}} else { this.id = null;} return (A) this;
    }

    public A withId(String... id) {
        if (this.id != null) {this.id.clear();}
        if (id != null) {for (String item :id){ this.addToId(item);}} return (A) this;
    }

    public Boolean hasId() {
        return id != null && !id.isEmpty();
    }

    public A addNewId(String arg1) {
        return (A)addToId(new String(arg1));
    }

    public A addNewId(StringBuilder arg1) {
        return (A)addToId(new String(arg1));
    }

    public A addNewId(StringBuffer arg1) {
        return (A)addToId(new String(arg1));
    }

    public A addToName(int index,String item) {
        if (this.name == null) {this.name = new ArrayList<String>();}
        this.name.add(index, item);
        return (A)this;
    }

    public A setToName(int index,String item) {
        if (this.name == null) {this.name = new ArrayList<String>();}
        this.name.set(index, item); return (A)this;
    }

    public A addToName(String... items) {
        if (this.name == null) {this.name = new ArrayList<String>();}
        for (String item : items) {this.name.add(item);} return (A)this;
    }

    public A addAllToName(Collection<String> items) {
        if (this.name == null) {this.name = new ArrayList<String>();}
        for (String item : items) {this.name.add(item);} return (A)this;
    }

    public A removeFromName(String... items) {
        for (String item : items) {if (this.name!= null){ this.name.remove(item);}} return (A)this;
    }

    public A removeAllFromName(Collection<String> items) {
        for (String item : items) {if (this.name!= null){ this.name.remove(item);}} return (A)this;
    }

    public List<String> getName() {
        return this.name;
    }

    public String getName(int index) {
        return this.name.get(index);
    }

    public String getFirstName() {
        return this.name.get(0);
    }

    public String getLastName() {
        return this.name.get(name.size() - 1);
    }

    public String getMatchingName(Predicate<String> predicate) {
        for (String item: name) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingName(Predicate<String> predicate) {
        for (String item: name) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withName(List<String> name) {
        if (this.name != null) { _visitables.get("name").removeAll(this.name);}
        if (name != null) {this.name = new ArrayList<String>(); for (String item : name){this.addToName(item);}} else { this.name = null;} return (A) this;
    }

    public A withName(String... name) {
        if (this.name != null) {this.name.clear();}
        if (name != null) {for (String item :name){ this.addToName(item);}} return (A) this;
    }

    public Boolean hasName() {
        return name != null && !name.isEmpty();
    }

    public A addNewName(String arg1) {
        return (A)addToName(new String(arg1));
    }

    public A addNewName(StringBuilder arg1) {
        return (A)addToName(new String(arg1));
    }

    public A addNewName(StringBuffer arg1) {
        return (A)addToName(new String(arg1));
    }

    public A addToPreferredUsername(int index,String item) {
        if (this.preferredUsername == null) {this.preferredUsername = new ArrayList<String>();}
        this.preferredUsername.add(index, item);
        return (A)this;
    }

    public A setToPreferredUsername(int index,String item) {
        if (this.preferredUsername == null) {this.preferredUsername = new ArrayList<String>();}
        this.preferredUsername.set(index, item); return (A)this;
    }

    public A addToPreferredUsername(String... items) {
        if (this.preferredUsername == null) {this.preferredUsername = new ArrayList<String>();}
        for (String item : items) {this.preferredUsername.add(item);} return (A)this;
    }

    public A addAllToPreferredUsername(Collection<String> items) {
        if (this.preferredUsername == null) {this.preferredUsername = new ArrayList<String>();}
        for (String item : items) {this.preferredUsername.add(item);} return (A)this;
    }

    public A removeFromPreferredUsername(String... items) {
        for (String item : items) {if (this.preferredUsername!= null){ this.preferredUsername.remove(item);}} return (A)this;
    }

    public A removeAllFromPreferredUsername(Collection<String> items) {
        for (String item : items) {if (this.preferredUsername!= null){ this.preferredUsername.remove(item);}} return (A)this;
    }

    public List<String> getPreferredUsername() {
        return this.preferredUsername;
    }

    public String getPreferredUsername(int index) {
        return this.preferredUsername.get(index);
    }

    public String getFirstPreferredUsername() {
        return this.preferredUsername.get(0);
    }

    public String getLastPreferredUsername() {
        return this.preferredUsername.get(preferredUsername.size() - 1);
    }

    public String getMatchingPreferredUsername(Predicate<String> predicate) {
        for (String item: preferredUsername) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingPreferredUsername(Predicate<String> predicate) {
        for (String item: preferredUsername) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withPreferredUsername(List<String> preferredUsername) {
        if (this.preferredUsername != null) { _visitables.get("preferredUsername").removeAll(this.preferredUsername);}
        if (preferredUsername != null) {this.preferredUsername = new ArrayList<String>(); for (String item : preferredUsername){this.addToPreferredUsername(item);}} else { this.preferredUsername = null;} return (A) this;
    }

    public A withPreferredUsername(String... preferredUsername) {
        if (this.preferredUsername != null) {this.preferredUsername.clear();}
        if (preferredUsername != null) {for (String item :preferredUsername){ this.addToPreferredUsername(item);}} return (A) this;
    }

    public Boolean hasPreferredUsername() {
        return preferredUsername != null && !preferredUsername.isEmpty();
    }

    public A addNewPreferredUsername(String arg1) {
        return (A)addToPreferredUsername(new String(arg1));
    }

    public A addNewPreferredUsername(StringBuilder arg1) {
        return (A)addToPreferredUsername(new String(arg1));
    }

    public A addNewPreferredUsername(StringBuffer arg1) {
        return (A)addToPreferredUsername(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        LDAPAttributeMappingFluentImpl that = (LDAPAttributeMappingFluentImpl) o;
        if (email != null ? !email.equals(that.email) :that.email != null) return false;
        if (id != null ? !id.equals(that.id) :that.id != null) return false;
        if (name != null ? !name.equals(that.name) :that.name != null) return false;
        if (preferredUsername != null ? !preferredUsername.equals(that.preferredUsername) :that.preferredUsername != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(email,  id,  name,  preferredUsername,  super.hashCode());
    }

}
