package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class GoogleIdentityProviderFluentImpl<A extends GoogleIdentityProviderFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements GoogleIdentityProviderFluent<A> {

    private String clientID;
    private SecretNameReferenceBuilder clientSecret;
    private String hostedDomain;

    public GoogleIdentityProviderFluentImpl() {
    }

    public GoogleIdentityProviderFluentImpl(GoogleIdentityProvider instance) {
        this.withClientID(instance.getClientID()); 
        this.withClientSecret(instance.getClientSecret()); 
        this.withHostedDomain(instance.getHostedDomain()); 
    }

    public String getClientID() {
        return this.clientID;
    }

    public A withClientID(String clientID) {
        this.clientID=clientID; return (A) this;
    }

    public Boolean hasClientID() {
        return this.clientID != null;
    }

    public A withNewClientID(String arg1) {
        return (A)withClientID(new String(arg1));
    }

    public A withNewClientID(StringBuilder arg1) {
        return (A)withClientID(new String(arg1));
    }

    public A withNewClientID(StringBuffer arg1) {
        return (A)withClientID(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildClientSecret instead.
 * @return The buildable object.
 */
@Deprecated public SecretNameReference getClientSecret() {
        return this.clientSecret!=null?this.clientSecret.build():null;
    }

    public SecretNameReference buildClientSecret() {
        return this.clientSecret!=null?this.clientSecret.build():null;
    }

    public A withClientSecret(SecretNameReference clientSecret) {
        _visitables.get("clientSecret").remove(this.clientSecret);
        if (clientSecret!=null){ this.clientSecret= new SecretNameReferenceBuilder(clientSecret); _visitables.get("clientSecret").add(this.clientSecret);} return (A) this;
    }

    public Boolean hasClientSecret() {
        return this.clientSecret != null;
    }

    public A withNewClientSecret(String name) {
        return (A)withClientSecret(new SecretNameReference(name));
    }

    public GoogleIdentityProviderFluent.ClientSecretNested<A> withNewClientSecret() {
        return new ClientSecretNestedImpl();
    }

    public GoogleIdentityProviderFluent.ClientSecretNested<A> withNewClientSecretLike(SecretNameReference item) {
        return new ClientSecretNestedImpl(item);
    }

    public GoogleIdentityProviderFluent.ClientSecretNested<A> editClientSecret() {
        return withNewClientSecretLike(getClientSecret());
    }

    public GoogleIdentityProviderFluent.ClientSecretNested<A> editOrNewClientSecret() {
        return withNewClientSecretLike(getClientSecret() != null ? getClientSecret(): new SecretNameReferenceBuilder().build());
    }

    public GoogleIdentityProviderFluent.ClientSecretNested<A> editOrNewClientSecretLike(SecretNameReference item) {
        return withNewClientSecretLike(getClientSecret() != null ? getClientSecret(): item);
    }

    public String getHostedDomain() {
        return this.hostedDomain;
    }

    public A withHostedDomain(String hostedDomain) {
        this.hostedDomain=hostedDomain; return (A) this;
    }

    public Boolean hasHostedDomain() {
        return this.hostedDomain != null;
    }

    public A withNewHostedDomain(String arg1) {
        return (A)withHostedDomain(new String(arg1));
    }

    public A withNewHostedDomain(StringBuilder arg1) {
        return (A)withHostedDomain(new String(arg1));
    }

    public A withNewHostedDomain(StringBuffer arg1) {
        return (A)withHostedDomain(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        GoogleIdentityProviderFluentImpl that = (GoogleIdentityProviderFluentImpl) o;
        if (clientID != null ? !clientID.equals(that.clientID) :that.clientID != null) return false;
        if (clientSecret != null ? !clientSecret.equals(that.clientSecret) :that.clientSecret != null) return false;
        if (hostedDomain != null ? !hostedDomain.equals(that.hostedDomain) :that.hostedDomain != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(clientID,  clientSecret,  hostedDomain,  super.hashCode());
    }

    public class ClientSecretNestedImpl<N> extends SecretNameReferenceFluentImpl<GoogleIdentityProviderFluent.ClientSecretNested<N>> implements GoogleIdentityProviderFluent.ClientSecretNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final SecretNameReferenceBuilder builder;

            ClientSecretNestedImpl(SecretNameReference item) {
                this.builder = new SecretNameReferenceBuilder(this, item);
                        
            }

            ClientSecretNestedImpl() {
                this.builder = new SecretNameReferenceBuilder(this);
                        
            }

            public N and() {
                return (N) GoogleIdentityProviderFluentImpl.this.withClientSecret(builder.build());
            }

            public N endClientSecret() {
                return and();
            }
    }


}
