package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class HTPasswdIdentityProviderBuilder extends HTPasswdIdentityProviderFluentImpl<HTPasswdIdentityProviderBuilder> implements VisitableBuilder<HTPasswdIdentityProvider,HTPasswdIdentityProviderBuilder> {

    HTPasswdIdentityProviderFluent<?> fluent;
    Boolean validationEnabled;

    public HTPasswdIdentityProviderBuilder() {
        this(true);
    }

    public HTPasswdIdentityProviderBuilder(Boolean validationEnabled) {
        this(new HTPasswdIdentityProvider(), validationEnabled);
    }

    public HTPasswdIdentityProviderBuilder(HTPasswdIdentityProviderFluent<?> fluent) {
        this(fluent, true);
    }

    public HTPasswdIdentityProviderBuilder(HTPasswdIdentityProviderFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new HTPasswdIdentityProvider(), validationEnabled);
    }

    public HTPasswdIdentityProviderBuilder(HTPasswdIdentityProviderFluent<?> fluent,HTPasswdIdentityProvider instance) {
        this(fluent, instance, true);
    }

    public HTPasswdIdentityProviderBuilder(HTPasswdIdentityProviderFluent<?> fluent,HTPasswdIdentityProvider instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withFileData(instance.getFileData()); 
        this.validationEnabled = validationEnabled; 
    }

    public HTPasswdIdentityProviderBuilder(HTPasswdIdentityProvider instance) {
        this(instance,true);
    }

    public HTPasswdIdentityProviderBuilder(HTPasswdIdentityProvider instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withFileData(instance.getFileData()); 
        this.validationEnabled = validationEnabled; 
    }

    public HTPasswdIdentityProvider build() {
        HTPasswdIdentityProvider buildable = new HTPasswdIdentityProvider(fluent.getFileData());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        HTPasswdIdentityProviderBuilder that = (HTPasswdIdentityProviderBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
