package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface InfrastructureListFluent<A extends InfrastructureListFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToItems(int index,Infrastructure item);
    public A setToItems(int index,Infrastructure item);
    public A addToItems(Infrastructure... items);
    public A addAllToItems(Collection<Infrastructure> items);
    public A removeFromItems(Infrastructure... items);
    public A removeAllFromItems(Collection<Infrastructure> items);
    public A removeMatchingFromItems(Predicate<InfrastructureBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<Infrastructure> getItems();
    public List<Infrastructure> buildItems();
    public Infrastructure buildItem(int index);
    public Infrastructure buildFirstItem();
    public Infrastructure buildLastItem();
    public Infrastructure buildMatchingItem(Predicate<InfrastructureBuilder> predicate);
    public Boolean hasMatchingItem(Predicate<InfrastructureBuilder> predicate);
    public A withItems(List<Infrastructure> items);
    public A withItems(Infrastructure... items);
    public Boolean hasItems();
    public InfrastructureListFluent.ItemsNested<A> addNewItem();
    public InfrastructureListFluent.ItemsNested<A> addNewItemLike(Infrastructure item);
    public InfrastructureListFluent.ItemsNested<A> setNewItemLike(int index,Infrastructure item);
    public InfrastructureListFluent.ItemsNested<A> editItem(int index);
    public InfrastructureListFluent.ItemsNested<A> editFirstItem();
    public InfrastructureListFluent.ItemsNested<A> editLastItem();
    public InfrastructureListFluent.ItemsNested<A> editMatchingItem(Predicate<InfrastructureBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);
    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,InfrastructureFluent<InfrastructureListFluent.ItemsNested<N>> {

            public N and();
            public N endItem();    }


}
