package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class PlatformStatusBuilder extends PlatformStatusFluentImpl<PlatformStatusBuilder> implements VisitableBuilder<PlatformStatus,PlatformStatusBuilder> {

    PlatformStatusFluent<?> fluent;
    Boolean validationEnabled;

    public PlatformStatusBuilder() {
        this(true);
    }

    public PlatformStatusBuilder(Boolean validationEnabled) {
        this(new PlatformStatus(), validationEnabled);
    }

    public PlatformStatusBuilder(PlatformStatusFluent<?> fluent) {
        this(fluent, true);
    }

    public PlatformStatusBuilder(PlatformStatusFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new PlatformStatus(), validationEnabled);
    }

    public PlatformStatusBuilder(PlatformStatusFluent<?> fluent,PlatformStatus instance) {
        this(fluent, instance, true);
    }

    public PlatformStatusBuilder(PlatformStatusFluent<?> fluent,PlatformStatus instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withAws(instance.getAws()); 
        fluent.withAzure(instance.getAzure()); 
        fluent.withBaremetal(instance.getBaremetal()); 
        fluent.withGcp(instance.getGcp()); 
        fluent.withIbmcloud(instance.getIbmcloud()); 
        fluent.withOpenstack(instance.getOpenstack()); 
        fluent.withOvirt(instance.getOvirt()); 
        fluent.withType(instance.getType()); 
        fluent.withVsphere(instance.getVsphere()); 
        this.validationEnabled = validationEnabled; 
    }

    public PlatformStatusBuilder(PlatformStatus instance) {
        this(instance,true);
    }

    public PlatformStatusBuilder(PlatformStatus instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withAws(instance.getAws()); 
        this.withAzure(instance.getAzure()); 
        this.withBaremetal(instance.getBaremetal()); 
        this.withGcp(instance.getGcp()); 
        this.withIbmcloud(instance.getIbmcloud()); 
        this.withOpenstack(instance.getOpenstack()); 
        this.withOvirt(instance.getOvirt()); 
        this.withType(instance.getType()); 
        this.withVsphere(instance.getVsphere()); 
        this.validationEnabled = validationEnabled; 
    }

    public PlatformStatus build() {
        PlatformStatus buildable = new PlatformStatus(fluent.getAws(),fluent.getAzure(),fluent.getBaremetal(),fluent.getGcp(),fluent.getIbmcloud(),fluent.getOpenstack(),fluent.getOvirt(),fluent.getType(),fluent.getVsphere());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        PlatformStatusBuilder that = (PlatformStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
