package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class AppliedClusterResourceQuotaListBuilder extends AppliedClusterResourceQuotaListFluentImpl<AppliedClusterResourceQuotaListBuilder> implements VisitableBuilder<AppliedClusterResourceQuotaList,AppliedClusterResourceQuotaListBuilder> {

    AppliedClusterResourceQuotaListFluent<?> fluent;
    Boolean validationEnabled;

    public AppliedClusterResourceQuotaListBuilder() {
        this(true);
    }

    public AppliedClusterResourceQuotaListBuilder(Boolean validationEnabled) {
        this(new AppliedClusterResourceQuotaList(), validationEnabled);
    }

    public AppliedClusterResourceQuotaListBuilder(AppliedClusterResourceQuotaListFluent<?> fluent) {
        this(fluent, true);
    }

    public AppliedClusterResourceQuotaListBuilder(AppliedClusterResourceQuotaListFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new AppliedClusterResourceQuotaList(), validationEnabled);
    }

    public AppliedClusterResourceQuotaListBuilder(AppliedClusterResourceQuotaListFluent<?> fluent,AppliedClusterResourceQuotaList instance) {
        this(fluent, instance, true);
    }

    public AppliedClusterResourceQuotaListBuilder(AppliedClusterResourceQuotaListFluent<?> fluent,AppliedClusterResourceQuotaList instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public AppliedClusterResourceQuotaListBuilder(AppliedClusterResourceQuotaList instance) {
        this(instance,true);
    }

    public AppliedClusterResourceQuotaListBuilder(AppliedClusterResourceQuotaList instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public AppliedClusterResourceQuotaList build() {
        AppliedClusterResourceQuotaList buildable = new AppliedClusterResourceQuotaList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        AppliedClusterResourceQuotaListBuilder that = (AppliedClusterResourceQuotaListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
