package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface ClusterVersionListFluent<A extends ClusterVersionListFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToItems(int index,ClusterVersion item);
    public A setToItems(int index,ClusterVersion item);
    public A addToItems(ClusterVersion... items);
    public A addAllToItems(Collection<ClusterVersion> items);
    public A removeFromItems(ClusterVersion... items);
    public A removeAllFromItems(Collection<ClusterVersion> items);
    public A removeMatchingFromItems(Predicate<ClusterVersionBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<ClusterVersion> getItems();
    public List<ClusterVersion> buildItems();
    public ClusterVersion buildItem(int index);
    public ClusterVersion buildFirstItem();
    public ClusterVersion buildLastItem();
    public ClusterVersion buildMatchingItem(Predicate<ClusterVersionBuilder> predicate);
    public Boolean hasMatchingItem(Predicate<ClusterVersionBuilder> predicate);
    public A withItems(List<ClusterVersion> items);
    public A withItems(ClusterVersion... items);
    public Boolean hasItems();
    public ClusterVersionListFluent.ItemsNested<A> addNewItem();
    public ClusterVersionListFluent.ItemsNested<A> addNewItemLike(ClusterVersion item);
    public ClusterVersionListFluent.ItemsNested<A> setNewItemLike(int index,ClusterVersion item);
    public ClusterVersionListFluent.ItemsNested<A> editItem(int index);
    public ClusterVersionListFluent.ItemsNested<A> editFirstItem();
    public ClusterVersionListFluent.ItemsNested<A> editLastItem();
    public ClusterVersionListFluent.ItemsNested<A> editMatchingItem(Predicate<ClusterVersionBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);
    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ClusterVersionFluent<ClusterVersionListFluent.ItemsNested<N>> {

            public N and();
            public N endItem();    }


}
