package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class OperatorHubSpecFluentImpl<A extends OperatorHubSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements OperatorHubSpecFluent<A> {

    private Boolean disableAllDefaultSources;
    private List<HubSourceBuilder> sources =  new ArrayList<HubSourceBuilder>();

    public OperatorHubSpecFluentImpl() {
    }

    public OperatorHubSpecFluentImpl(OperatorHubSpec instance) {
        this.withDisableAllDefaultSources(instance.getDisableAllDefaultSources()); 
        this.withSources(instance.getSources()); 
    }

    public Boolean isDisableAllDefaultSources() {
        return this.disableAllDefaultSources;
    }

    public A withDisableAllDefaultSources(Boolean disableAllDefaultSources) {
        this.disableAllDefaultSources=disableAllDefaultSources; return (A) this;
    }

    public Boolean hasDisableAllDefaultSources() {
        return this.disableAllDefaultSources != null;
    }

    public A withNewDisableAllDefaultSources(String arg1) {
        return (A)withDisableAllDefaultSources(new Boolean(arg1));
    }

    public A withNewDisableAllDefaultSources(boolean arg1) {
        return (A)withDisableAllDefaultSources(new Boolean(arg1));
    }

    public A addToSources(int index,HubSource item) {
        if (this.sources == null) {this.sources = new ArrayList<HubSourceBuilder>();}
        HubSourceBuilder builder = new HubSourceBuilder(item);_visitables.get("sources").add(index >= 0 ? index : _visitables.get("sources").size(), builder);this.sources.add(index >= 0 ? index : sources.size(), builder); return (A)this;
    }

    public A setToSources(int index,HubSource item) {
        if (this.sources == null) {this.sources = new ArrayList<HubSourceBuilder>();}
        HubSourceBuilder builder = new HubSourceBuilder(item);
        if (index < 0 || index >= _visitables.get("sources").size()) { _visitables.get("sources").add(builder); } else { _visitables.get("sources").set(index, builder);}
        if (index < 0 || index >= sources.size()) { sources.add(builder); } else { sources.set(index, builder);}
         return (A)this;
    }

    public A addToSources(HubSource... items) {
        if (this.sources == null) {this.sources = new ArrayList<HubSourceBuilder>();}
        for (HubSource item : items) {HubSourceBuilder builder = new HubSourceBuilder(item);_visitables.get("sources").add(builder);this.sources.add(builder);} return (A)this;
    }

    public A addAllToSources(Collection<HubSource> items) {
        if (this.sources == null) {this.sources = new ArrayList<HubSourceBuilder>();}
        for (HubSource item : items) {HubSourceBuilder builder = new HubSourceBuilder(item);_visitables.get("sources").add(builder);this.sources.add(builder);} return (A)this;
    }

    public A removeFromSources(HubSource... items) {
        for (HubSource item : items) {HubSourceBuilder builder = new HubSourceBuilder(item);_visitables.get("sources").remove(builder);if (this.sources != null) {this.sources.remove(builder);}} return (A)this;
    }

    public A removeAllFromSources(Collection<HubSource> items) {
        for (HubSource item : items) {HubSourceBuilder builder = new HubSourceBuilder(item);_visitables.get("sources").remove(builder);if (this.sources != null) {this.sources.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromSources(Predicate<HubSourceBuilder> predicate) {
        if (sources == null) return (A) this;
        final Iterator<HubSourceBuilder> each = sources.iterator();
        final List visitables = _visitables.get("sources");
        while (each.hasNext()) {
          HubSourceBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildSources instead.
 * @return The buildable object.
 */
@Deprecated public List<HubSource> getSources() {
        return build(sources);
    }

    public List<HubSource> buildSources() {
        return build(sources);
    }

    public HubSource buildSource(int index) {
        return this.sources.get(index).build();
    }

    public HubSource buildFirstSource() {
        return this.sources.get(0).build();
    }

    public HubSource buildLastSource() {
        return this.sources.get(sources.size() - 1).build();
    }

    public HubSource buildMatchingSource(Predicate<HubSourceBuilder> predicate) {
        for (HubSourceBuilder item: sources) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingSource(Predicate<HubSourceBuilder> predicate) {
        for (HubSourceBuilder item: sources) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withSources(List<HubSource> sources) {
        if (this.sources != null) { _visitables.get("sources").removeAll(this.sources);}
        if (sources != null) {this.sources = new ArrayList<HubSourceBuilder>(); for (HubSource item : sources){this.addToSources(item);}} else { this.sources = null;} return (A) this;
    }

    public A withSources(HubSource... sources) {
        if (this.sources != null) {this.sources.clear();}
        if (sources != null) {for (HubSource item :sources){ this.addToSources(item);}} return (A) this;
    }

    public Boolean hasSources() {
        return sources != null && !sources.isEmpty();
    }

    public A addNewSource(Boolean disabled,String name) {
        return (A)addToSources(new HubSource(disabled, name));
    }

    public OperatorHubSpecFluent.SourcesNested<A> addNewSource() {
        return new SourcesNestedImpl();
    }

    public OperatorHubSpecFluent.SourcesNested<A> addNewSourceLike(HubSource item) {
        return new SourcesNestedImpl(-1, item);
    }

    public OperatorHubSpecFluent.SourcesNested<A> setNewSourceLike(int index,HubSource item) {
        return new SourcesNestedImpl(index, item);
    }

    public OperatorHubSpecFluent.SourcesNested<A> editSource(int index) {
        if (sources.size() <= index) throw new RuntimeException("Can't edit sources. Index exceeds size.");
        return setNewSourceLike(index, buildSource(index));
    }

    public OperatorHubSpecFluent.SourcesNested<A> editFirstSource() {
        if (sources.size() == 0) throw new RuntimeException("Can't edit first sources. The list is empty.");
        return setNewSourceLike(0, buildSource(0));
    }

    public OperatorHubSpecFluent.SourcesNested<A> editLastSource() {
        int index = sources.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last sources. The list is empty.");
        return setNewSourceLike(index, buildSource(index));
    }

    public OperatorHubSpecFluent.SourcesNested<A> editMatchingSource(Predicate<HubSourceBuilder> predicate) {
        int index = -1;
        for (int i=0;i<sources.size();i++) { 
        if (predicate.test(sources.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching sources. No match found.");
        return setNewSourceLike(index, buildSource(index));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        OperatorHubSpecFluentImpl that = (OperatorHubSpecFluentImpl) o;
        if (disableAllDefaultSources != null ? !disableAllDefaultSources.equals(that.disableAllDefaultSources) :that.disableAllDefaultSources != null) return false;
        if (sources != null ? !sources.equals(that.sources) :that.sources != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(disableAllDefaultSources,  sources,  super.hashCode());
    }

    public class SourcesNestedImpl<N> extends HubSourceFluentImpl<OperatorHubSpecFluent.SourcesNested<N>> implements OperatorHubSpecFluent.SourcesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final HubSourceBuilder builder;
        private final int index;

            SourcesNestedImpl(int index,HubSource item) {
                this.index = index;
                this.builder = new HubSourceBuilder(this, item);
                        
            }

            SourcesNestedImpl() {
                this.index = -1;
                this.builder = new HubSourceBuilder(this);
                        
            }

            public N and() {
                return (N) OperatorHubSpecFluentImpl.this.setToSources(index,builder.build());
            }

            public N endSource() {
                return and();
            }
    }


}
