package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class APIServerServingCertsBuilder extends APIServerServingCertsFluentImpl<APIServerServingCertsBuilder> implements VisitableBuilder<APIServerServingCerts,APIServerServingCertsBuilder> {

    APIServerServingCertsFluent<?> fluent;
    Boolean validationEnabled;

    public APIServerServingCertsBuilder() {
        this(true);
    }

    public APIServerServingCertsBuilder(Boolean validationEnabled) {
        this(new APIServerServingCerts(), validationEnabled);
    }

    public APIServerServingCertsBuilder(APIServerServingCertsFluent<?> fluent) {
        this(fluent, true);
    }

    public APIServerServingCertsBuilder(APIServerServingCertsFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new APIServerServingCerts(), validationEnabled);
    }

    public APIServerServingCertsBuilder(APIServerServingCertsFluent<?> fluent,APIServerServingCerts instance) {
        this(fluent, instance, true);
    }

    public APIServerServingCertsBuilder(APIServerServingCertsFluent<?> fluent,APIServerServingCerts instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withNamedCertificates(instance.getNamedCertificates()); 
        this.validationEnabled = validationEnabled; 
    }

    public APIServerServingCertsBuilder(APIServerServingCerts instance) {
        this(instance,true);
    }

    public APIServerServingCertsBuilder(APIServerServingCerts instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withNamedCertificates(instance.getNamedCertificates()); 
        this.validationEnabled = validationEnabled; 
    }

    public APIServerServingCerts build() {
        APIServerServingCerts buildable = new APIServerServingCerts(fluent.getNamedCertificates());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        APIServerServingCertsBuilder that = (APIServerServingCertsBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
