package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class APIServerStatusBuilder extends APIServerStatusFluentImpl<APIServerStatusBuilder> implements VisitableBuilder<APIServerStatus,APIServerStatusBuilder> {

    APIServerStatusFluent<?> fluent;
    Boolean validationEnabled;

    public APIServerStatusBuilder() {
        this(true);
    }

    public APIServerStatusBuilder(Boolean validationEnabled) {
        this(new APIServerStatus(), validationEnabled);
    }

    public APIServerStatusBuilder(APIServerStatusFluent<?> fluent) {
        this(fluent, true);
    }

    public APIServerStatusBuilder(APIServerStatusFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new APIServerStatus(), validationEnabled);
    }

    public APIServerStatusBuilder(APIServerStatusFluent<?> fluent,APIServerStatus instance) {
        this(fluent, instance, true);
    }

    public APIServerStatusBuilder(APIServerStatusFluent<?> fluent,APIServerStatus instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        this.validationEnabled = validationEnabled; 
    }

    public APIServerStatusBuilder(APIServerStatus instance) {
        this(instance,true);
    }

    public APIServerStatusBuilder(APIServerStatus instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.validationEnabled = validationEnabled; 
    }

    public APIServerStatus build() {
        APIServerStatus buildable = new APIServerStatus();
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        APIServerStatusBuilder that = (APIServerStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
