package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface AWSPlatformSpecFluent<A extends AWSPlatformSpecFluent<A>> extends Fluent<A> {


    public A addToServiceEndpoints(int index,AWSServiceEndpoint item);
    public A setToServiceEndpoints(int index,AWSServiceEndpoint item);
    public A addToServiceEndpoints(AWSServiceEndpoint... items);
    public A addAllToServiceEndpoints(Collection<AWSServiceEndpoint> items);
    public A removeFromServiceEndpoints(AWSServiceEndpoint... items);
    public A removeAllFromServiceEndpoints(Collection<AWSServiceEndpoint> items);
    public A removeMatchingFromServiceEndpoints(Predicate<AWSServiceEndpointBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildServiceEndpoints instead.
 * @return The buildable object.
 */
@Deprecated public List<AWSServiceEndpoint> getServiceEndpoints();
    public List<AWSServiceEndpoint> buildServiceEndpoints();
    public AWSServiceEndpoint buildServiceEndpoint(int index);
    public AWSServiceEndpoint buildFirstServiceEndpoint();
    public AWSServiceEndpoint buildLastServiceEndpoint();
    public AWSServiceEndpoint buildMatchingServiceEndpoint(Predicate<AWSServiceEndpointBuilder> predicate);
    public Boolean hasMatchingServiceEndpoint(Predicate<AWSServiceEndpointBuilder> predicate);
    public A withServiceEndpoints(List<AWSServiceEndpoint> serviceEndpoints);
    public A withServiceEndpoints(AWSServiceEndpoint... serviceEndpoints);
    public Boolean hasServiceEndpoints();
    public A addNewServiceEndpoint(String name,String url);
    public AWSPlatformSpecFluent.ServiceEndpointsNested<A> addNewServiceEndpoint();
    public AWSPlatformSpecFluent.ServiceEndpointsNested<A> addNewServiceEndpointLike(AWSServiceEndpoint item);
    public AWSPlatformSpecFluent.ServiceEndpointsNested<A> setNewServiceEndpointLike(int index,AWSServiceEndpoint item);
    public AWSPlatformSpecFluent.ServiceEndpointsNested<A> editServiceEndpoint(int index);
    public AWSPlatformSpecFluent.ServiceEndpointsNested<A> editFirstServiceEndpoint();
    public AWSPlatformSpecFluent.ServiceEndpointsNested<A> editLastServiceEndpoint();
    public AWSPlatformSpecFluent.ServiceEndpointsNested<A> editMatchingServiceEndpoint(Predicate<AWSServiceEndpointBuilder> predicate);
    public interface ServiceEndpointsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,AWSServiceEndpointFluent<AWSPlatformSpecFluent.ServiceEndpointsNested<N>> {

            public N and();
            public N endServiceEndpoint();    }


}
