package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class FeatureGateSpecFluentImpl<A extends FeatureGateSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements FeatureGateSpecFluent<A> {

    private CustomFeatureGatesBuilder customNoUpgrade;
    private String featureSet;

    public FeatureGateSpecFluentImpl() {
    }

    public FeatureGateSpecFluentImpl(FeatureGateSpec instance) {
        this.withCustomNoUpgrade(instance.getCustomNoUpgrade()); 
        this.withFeatureSet(instance.getFeatureSet()); 
    }

    
/**
 * This method has been deprecated, please use method buildCustomNoUpgrade instead.
 * @return The buildable object.
 */
@Deprecated public CustomFeatureGates getCustomNoUpgrade() {
        return this.customNoUpgrade!=null?this.customNoUpgrade.build():null;
    }

    public CustomFeatureGates buildCustomNoUpgrade() {
        return this.customNoUpgrade!=null?this.customNoUpgrade.build():null;
    }

    public A withCustomNoUpgrade(CustomFeatureGates customNoUpgrade) {
        _visitables.get("customNoUpgrade").remove(this.customNoUpgrade);
        if (customNoUpgrade!=null){ this.customNoUpgrade= new CustomFeatureGatesBuilder(customNoUpgrade); _visitables.get("customNoUpgrade").add(this.customNoUpgrade);} return (A) this;
    }

    public Boolean hasCustomNoUpgrade() {
        return this.customNoUpgrade != null;
    }

    public FeatureGateSpecFluent.CustomNoUpgradeNested<A> withNewCustomNoUpgrade() {
        return new CustomNoUpgradeNestedImpl();
    }

    public FeatureGateSpecFluent.CustomNoUpgradeNested<A> withNewCustomNoUpgradeLike(CustomFeatureGates item) {
        return new CustomNoUpgradeNestedImpl(item);
    }

    public FeatureGateSpecFluent.CustomNoUpgradeNested<A> editCustomNoUpgrade() {
        return withNewCustomNoUpgradeLike(getCustomNoUpgrade());
    }

    public FeatureGateSpecFluent.CustomNoUpgradeNested<A> editOrNewCustomNoUpgrade() {
        return withNewCustomNoUpgradeLike(getCustomNoUpgrade() != null ? getCustomNoUpgrade(): new CustomFeatureGatesBuilder().build());
    }

    public FeatureGateSpecFluent.CustomNoUpgradeNested<A> editOrNewCustomNoUpgradeLike(CustomFeatureGates item) {
        return withNewCustomNoUpgradeLike(getCustomNoUpgrade() != null ? getCustomNoUpgrade(): item);
    }

    public String getFeatureSet() {
        return this.featureSet;
    }

    public A withFeatureSet(String featureSet) {
        this.featureSet=featureSet; return (A) this;
    }

    public Boolean hasFeatureSet() {
        return this.featureSet != null;
    }

    public A withNewFeatureSet(String arg1) {
        return (A)withFeatureSet(new String(arg1));
    }

    public A withNewFeatureSet(StringBuilder arg1) {
        return (A)withFeatureSet(new String(arg1));
    }

    public A withNewFeatureSet(StringBuffer arg1) {
        return (A)withFeatureSet(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        FeatureGateSpecFluentImpl that = (FeatureGateSpecFluentImpl) o;
        if (customNoUpgrade != null ? !customNoUpgrade.equals(that.customNoUpgrade) :that.customNoUpgrade != null) return false;
        if (featureSet != null ? !featureSet.equals(that.featureSet) :that.featureSet != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(customNoUpgrade,  featureSet,  super.hashCode());
    }

    public class CustomNoUpgradeNestedImpl<N> extends CustomFeatureGatesFluentImpl<FeatureGateSpecFluent.CustomNoUpgradeNested<N>> implements FeatureGateSpecFluent.CustomNoUpgradeNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final CustomFeatureGatesBuilder builder;

            CustomNoUpgradeNestedImpl(CustomFeatureGates item) {
                this.builder = new CustomFeatureGatesBuilder(this, item);
                        
            }

            CustomNoUpgradeNestedImpl() {
                this.builder = new CustomFeatureGatesBuilder(this);
                        
            }

            public N and() {
                return (N) FeatureGateSpecFluentImpl.this.withCustomNoUpgrade(builder.build());
            }

            public N endCustomNoUpgrade() {
                return and();
            }
    }


}
