package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ProxySpecBuilder extends ProxySpecFluentImpl<ProxySpecBuilder> implements VisitableBuilder<ProxySpec,ProxySpecBuilder> {

    ProxySpecFluent<?> fluent;
    Boolean validationEnabled;

    public ProxySpecBuilder() {
        this(true);
    }

    public ProxySpecBuilder(Boolean validationEnabled) {
        this(new ProxySpec(), validationEnabled);
    }

    public ProxySpecBuilder(ProxySpecFluent<?> fluent) {
        this(fluent, true);
    }

    public ProxySpecBuilder(ProxySpecFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new ProxySpec(), validationEnabled);
    }

    public ProxySpecBuilder(ProxySpecFluent<?> fluent,ProxySpec instance) {
        this(fluent, instance, true);
    }

    public ProxySpecBuilder(ProxySpecFluent<?> fluent,ProxySpec instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withHttpProxy(instance.getHttpProxy()); 
        fluent.withHttpsProxy(instance.getHttpsProxy()); 
        fluent.withNoProxy(instance.getNoProxy()); 
        fluent.withReadinessEndpoints(instance.getReadinessEndpoints()); 
        fluent.withTrustedCA(instance.getTrustedCA()); 
        this.validationEnabled = validationEnabled; 
    }

    public ProxySpecBuilder(ProxySpec instance) {
        this(instance,true);
    }

    public ProxySpecBuilder(ProxySpec instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withHttpProxy(instance.getHttpProxy()); 
        this.withHttpsProxy(instance.getHttpsProxy()); 
        this.withNoProxy(instance.getNoProxy()); 
        this.withReadinessEndpoints(instance.getReadinessEndpoints()); 
        this.withTrustedCA(instance.getTrustedCA()); 
        this.validationEnabled = validationEnabled; 
    }

    public ProxySpec build() {
        ProxySpec buildable = new ProxySpec(fluent.getHttpProxy(),fluent.getHttpsProxy(),fluent.getNoProxy(),fluent.getReadinessEndpoints(),fluent.getTrustedCA());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ProxySpecBuilder that = (ProxySpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
