package io.fabric8.openshift.api.model;

import java.lang.Integer;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.Duration;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;

public interface TokenConfigFluent<A extends TokenConfigFluent<A>> extends Fluent<A> {


    public Duration getAccessTokenInactivityTimeout();
    public A withAccessTokenInactivityTimeout(Duration accessTokenInactivityTimeout);
    public Boolean hasAccessTokenInactivityTimeout();
    public Integer getAccessTokenInactivityTimeoutSeconds();
    public A withAccessTokenInactivityTimeoutSeconds(Integer accessTokenInactivityTimeoutSeconds);
    public Boolean hasAccessTokenInactivityTimeoutSeconds();
    public Integer getAccessTokenMaxAgeSeconds();
    public A withAccessTokenMaxAgeSeconds(Integer accessTokenMaxAgeSeconds);
    public Boolean hasAccessTokenMaxAgeSeconds();
}
