package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class AWSServiceEndpointBuilder extends AWSServiceEndpointFluentImpl<AWSServiceEndpointBuilder> implements VisitableBuilder<AWSServiceEndpoint,AWSServiceEndpointBuilder> {

    AWSServiceEndpointFluent<?> fluent;
    Boolean validationEnabled;

    public AWSServiceEndpointBuilder() {
        this(true);
    }

    public AWSServiceEndpointBuilder(Boolean validationEnabled) {
        this(new AWSServiceEndpoint(), validationEnabled);
    }

    public AWSServiceEndpointBuilder(AWSServiceEndpointFluent<?> fluent) {
        this(fluent, true);
    }

    public AWSServiceEndpointBuilder(AWSServiceEndpointFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new AWSServiceEndpoint(), validationEnabled);
    }

    public AWSServiceEndpointBuilder(AWSServiceEndpointFluent<?> fluent,AWSServiceEndpoint instance) {
        this(fluent, instance, true);
    }

    public AWSServiceEndpointBuilder(AWSServiceEndpointFluent<?> fluent,AWSServiceEndpoint instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withName(instance.getName()); 
        fluent.withUrl(instance.getUrl()); 
        this.validationEnabled = validationEnabled; 
    }

    public AWSServiceEndpointBuilder(AWSServiceEndpoint instance) {
        this(instance,true);
    }

    public AWSServiceEndpointBuilder(AWSServiceEndpoint instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withName(instance.getName()); 
        this.withUrl(instance.getUrl()); 
        this.validationEnabled = validationEnabled; 
    }

    public AWSServiceEndpoint build() {
        AWSServiceEndpoint buildable = new AWSServiceEndpoint(fluent.getName(),fluent.getUrl());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        AWSServiceEndpointBuilder that = (AWSServiceEndpointBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
