package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class GitLabIdentityProviderFluentImpl<A extends GitLabIdentityProviderFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements GitLabIdentityProviderFluent<A> {

    private ConfigMapNameReferenceBuilder ca;
    private String clientID;
    private SecretNameReferenceBuilder clientSecret;
    private String url;

    public GitLabIdentityProviderFluentImpl() {
    }

    public GitLabIdentityProviderFluentImpl(GitLabIdentityProvider instance) {
        this.withCa(instance.getCa()); 
        this.withClientID(instance.getClientID()); 
        this.withClientSecret(instance.getClientSecret()); 
        this.withUrl(instance.getUrl()); 
    }

    
/**
 * This method has been deprecated, please use method buildCa instead.
 * @return The buildable object.
 */
@Deprecated public ConfigMapNameReference getCa() {
        return this.ca!=null?this.ca.build():null;
    }

    public ConfigMapNameReference buildCa() {
        return this.ca!=null?this.ca.build():null;
    }

    public A withCa(ConfigMapNameReference ca) {
        _visitables.get("ca").remove(this.ca);
        if (ca!=null){ this.ca= new ConfigMapNameReferenceBuilder(ca); _visitables.get("ca").add(this.ca);} return (A) this;
    }

    public Boolean hasCa() {
        return this.ca != null;
    }

    public A withNewCa(String name) {
        return (A)withCa(new ConfigMapNameReference(name));
    }

    public GitLabIdentityProviderFluent.CaNested<A> withNewCa() {
        return new CaNestedImpl();
    }

    public GitLabIdentityProviderFluent.CaNested<A> withNewCaLike(ConfigMapNameReference item) {
        return new CaNestedImpl(item);
    }

    public GitLabIdentityProviderFluent.CaNested<A> editCa() {
        return withNewCaLike(getCa());
    }

    public GitLabIdentityProviderFluent.CaNested<A> editOrNewCa() {
        return withNewCaLike(getCa() != null ? getCa(): new ConfigMapNameReferenceBuilder().build());
    }

    public GitLabIdentityProviderFluent.CaNested<A> editOrNewCaLike(ConfigMapNameReference item) {
        return withNewCaLike(getCa() != null ? getCa(): item);
    }

    public String getClientID() {
        return this.clientID;
    }

    public A withClientID(String clientID) {
        this.clientID=clientID; return (A) this;
    }

    public Boolean hasClientID() {
        return this.clientID != null;
    }

    public A withNewClientID(String arg1) {
        return (A)withClientID(new String(arg1));
    }

    public A withNewClientID(StringBuilder arg1) {
        return (A)withClientID(new String(arg1));
    }

    public A withNewClientID(StringBuffer arg1) {
        return (A)withClientID(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildClientSecret instead.
 * @return The buildable object.
 */
@Deprecated public SecretNameReference getClientSecret() {
        return this.clientSecret!=null?this.clientSecret.build():null;
    }

    public SecretNameReference buildClientSecret() {
        return this.clientSecret!=null?this.clientSecret.build():null;
    }

    public A withClientSecret(SecretNameReference clientSecret) {
        _visitables.get("clientSecret").remove(this.clientSecret);
        if (clientSecret!=null){ this.clientSecret= new SecretNameReferenceBuilder(clientSecret); _visitables.get("clientSecret").add(this.clientSecret);} return (A) this;
    }

    public Boolean hasClientSecret() {
        return this.clientSecret != null;
    }

    public A withNewClientSecret(String name) {
        return (A)withClientSecret(new SecretNameReference(name));
    }

    public GitLabIdentityProviderFluent.ClientSecretNested<A> withNewClientSecret() {
        return new ClientSecretNestedImpl();
    }

    public GitLabIdentityProviderFluent.ClientSecretNested<A> withNewClientSecretLike(SecretNameReference item) {
        return new ClientSecretNestedImpl(item);
    }

    public GitLabIdentityProviderFluent.ClientSecretNested<A> editClientSecret() {
        return withNewClientSecretLike(getClientSecret());
    }

    public GitLabIdentityProviderFluent.ClientSecretNested<A> editOrNewClientSecret() {
        return withNewClientSecretLike(getClientSecret() != null ? getClientSecret(): new SecretNameReferenceBuilder().build());
    }

    public GitLabIdentityProviderFluent.ClientSecretNested<A> editOrNewClientSecretLike(SecretNameReference item) {
        return withNewClientSecretLike(getClientSecret() != null ? getClientSecret(): item);
    }

    public String getUrl() {
        return this.url;
    }

    public A withUrl(String url) {
        this.url=url; return (A) this;
    }

    public Boolean hasUrl() {
        return this.url != null;
    }

    public A withNewUrl(String arg1) {
        return (A)withUrl(new String(arg1));
    }

    public A withNewUrl(StringBuilder arg1) {
        return (A)withUrl(new String(arg1));
    }

    public A withNewUrl(StringBuffer arg1) {
        return (A)withUrl(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        GitLabIdentityProviderFluentImpl that = (GitLabIdentityProviderFluentImpl) o;
        if (ca != null ? !ca.equals(that.ca) :that.ca != null) return false;
        if (clientID != null ? !clientID.equals(that.clientID) :that.clientID != null) return false;
        if (clientSecret != null ? !clientSecret.equals(that.clientSecret) :that.clientSecret != null) return false;
        if (url != null ? !url.equals(that.url) :that.url != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(ca,  clientID,  clientSecret,  url,  super.hashCode());
    }

    public class CaNestedImpl<N> extends ConfigMapNameReferenceFluentImpl<GitLabIdentityProviderFluent.CaNested<N>> implements GitLabIdentityProviderFluent.CaNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ConfigMapNameReferenceBuilder builder;

            CaNestedImpl(ConfigMapNameReference item) {
                this.builder = new ConfigMapNameReferenceBuilder(this, item);
                        
            }

            CaNestedImpl() {
                this.builder = new ConfigMapNameReferenceBuilder(this);
                        
            }

            public N and() {
                return (N) GitLabIdentityProviderFluentImpl.this.withCa(builder.build());
            }

            public N endCa() {
                return and();
            }
    }


    public class ClientSecretNestedImpl<N> extends SecretNameReferenceFluentImpl<GitLabIdentityProviderFluent.ClientSecretNested<N>> implements GitLabIdentityProviderFluent.ClientSecretNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final SecretNameReferenceBuilder builder;

            ClientSecretNestedImpl(SecretNameReference item) {
                this.builder = new SecretNameReferenceBuilder(this, item);
                        
            }

            ClientSecretNestedImpl() {
                this.builder = new SecretNameReferenceBuilder(this);
                        
            }

            public N and() {
                return (N) GitLabIdentityProviderFluentImpl.this.withClientSecret(builder.build());
            }

            public N endClientSecret() {
                return and();
            }
    }


}
