package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class OpenIDIdentityProviderBuilder extends OpenIDIdentityProviderFluentImpl<OpenIDIdentityProviderBuilder> implements VisitableBuilder<OpenIDIdentityProvider,OpenIDIdentityProviderBuilder> {

    OpenIDIdentityProviderFluent<?> fluent;
    Boolean validationEnabled;

    public OpenIDIdentityProviderBuilder() {
        this(true);
    }

    public OpenIDIdentityProviderBuilder(Boolean validationEnabled) {
        this(new OpenIDIdentityProvider(), validationEnabled);
    }

    public OpenIDIdentityProviderBuilder(OpenIDIdentityProviderFluent<?> fluent) {
        this(fluent, true);
    }

    public OpenIDIdentityProviderBuilder(OpenIDIdentityProviderFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new OpenIDIdentityProvider(), validationEnabled);
    }

    public OpenIDIdentityProviderBuilder(OpenIDIdentityProviderFluent<?> fluent,OpenIDIdentityProvider instance) {
        this(fluent, instance, true);
    }

    public OpenIDIdentityProviderBuilder(OpenIDIdentityProviderFluent<?> fluent,OpenIDIdentityProvider instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withCa(instance.getCa()); 
        fluent.withClaims(instance.getClaims()); 
        fluent.withClientID(instance.getClientID()); 
        fluent.withClientSecret(instance.getClientSecret()); 
        fluent.withExtraAuthorizeParameters(instance.getExtraAuthorizeParameters()); 
        fluent.withExtraScopes(instance.getExtraScopes()); 
        fluent.withIssuer(instance.getIssuer()); 
        this.validationEnabled = validationEnabled; 
    }

    public OpenIDIdentityProviderBuilder(OpenIDIdentityProvider instance) {
        this(instance,true);
    }

    public OpenIDIdentityProviderBuilder(OpenIDIdentityProvider instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withCa(instance.getCa()); 
        this.withClaims(instance.getClaims()); 
        this.withClientID(instance.getClientID()); 
        this.withClientSecret(instance.getClientSecret()); 
        this.withExtraAuthorizeParameters(instance.getExtraAuthorizeParameters()); 
        this.withExtraScopes(instance.getExtraScopes()); 
        this.withIssuer(instance.getIssuer()); 
        this.validationEnabled = validationEnabled; 
    }

    public OpenIDIdentityProvider build() {
        OpenIDIdentityProvider buildable = new OpenIDIdentityProvider(fluent.getCa(),fluent.getClaims(),fluent.getClientID(),fluent.getClientSecret(),fluent.getExtraAuthorizeParameters(),fluent.getExtraScopes(),fluent.getIssuer());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        OpenIDIdentityProviderBuilder that = (OpenIDIdentityProviderBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
