package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.ResourceQuotaStatus;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface ClusterResourceQuotaStatusFluent<A extends ClusterResourceQuotaStatusFluent<A>> extends Fluent<A> {


    public A addToNamespaces(int index,ResourceQuotaStatusByNamespace item);
    public A setToNamespaces(int index,ResourceQuotaStatusByNamespace item);
    public A addToNamespaces(ResourceQuotaStatusByNamespace... items);
    public A addAllToNamespaces(Collection<ResourceQuotaStatusByNamespace> items);
    public A removeFromNamespaces(ResourceQuotaStatusByNamespace... items);
    public A removeAllFromNamespaces(Collection<ResourceQuotaStatusByNamespace> items);
    public A removeMatchingFromNamespaces(Predicate<ResourceQuotaStatusByNamespaceBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildNamespaces instead.
 * @return The buildable object.
 */
@Deprecated public List<ResourceQuotaStatusByNamespace> getNamespaces();
    public List<ResourceQuotaStatusByNamespace> buildNamespaces();
    public ResourceQuotaStatusByNamespace buildNamespace(int index);
    public ResourceQuotaStatusByNamespace buildFirstNamespace();
    public ResourceQuotaStatusByNamespace buildLastNamespace();
    public ResourceQuotaStatusByNamespace buildMatchingNamespace(Predicate<ResourceQuotaStatusByNamespaceBuilder> predicate);
    public Boolean hasMatchingNamespace(Predicate<ResourceQuotaStatusByNamespaceBuilder> predicate);
    public A withNamespaces(List<ResourceQuotaStatusByNamespace> namespaces);
    public A withNamespaces(ResourceQuotaStatusByNamespace... namespaces);
    public Boolean hasNamespaces();
    public ClusterResourceQuotaStatusFluent.NamespacesNested<A> addNewNamespace();
    public ClusterResourceQuotaStatusFluent.NamespacesNested<A> addNewNamespaceLike(ResourceQuotaStatusByNamespace item);
    public ClusterResourceQuotaStatusFluent.NamespacesNested<A> setNewNamespaceLike(int index,ResourceQuotaStatusByNamespace item);
    public ClusterResourceQuotaStatusFluent.NamespacesNested<A> editNamespace(int index);
    public ClusterResourceQuotaStatusFluent.NamespacesNested<A> editFirstNamespace();
    public ClusterResourceQuotaStatusFluent.NamespacesNested<A> editLastNamespace();
    public ClusterResourceQuotaStatusFluent.NamespacesNested<A> editMatchingNamespace(Predicate<ResourceQuotaStatusByNamespaceBuilder> predicate);
    public ResourceQuotaStatus getTotal();
    public A withTotal(ResourceQuotaStatus total);
    public Boolean hasTotal();
    public interface NamespacesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ResourceQuotaStatusByNamespaceFluent<ClusterResourceQuotaStatusFluent.NamespacesNested<N>> {

            public N and();
            public N endNamespace();    }


}
