package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface ImageStreamStatusFluent<A extends ImageStreamStatusFluent<A>> extends Fluent<A> {


    public String getDockerImageRepository();
    public A withDockerImageRepository(String dockerImageRepository);
    public Boolean hasDockerImageRepository();
    public A withNewDockerImageRepository(String arg1);
    public A withNewDockerImageRepository(StringBuilder arg1);
    public A withNewDockerImageRepository(StringBuffer arg1);
    public String getPublicDockerImageRepository();
    public A withPublicDockerImageRepository(String publicDockerImageRepository);
    public Boolean hasPublicDockerImageRepository();
    public A withNewPublicDockerImageRepository(String arg1);
    public A withNewPublicDockerImageRepository(StringBuilder arg1);
    public A withNewPublicDockerImageRepository(StringBuffer arg1);
    public A addToTags(int index,NamedTagEventList item);
    public A setToTags(int index,NamedTagEventList item);
    public A addToTags(NamedTagEventList... items);
    public A addAllToTags(Collection<NamedTagEventList> items);
    public A removeFromTags(NamedTagEventList... items);
    public A removeAllFromTags(Collection<NamedTagEventList> items);
    public A removeMatchingFromTags(Predicate<NamedTagEventListBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildTags instead.
 * @return The buildable object.
 */
@Deprecated public List<NamedTagEventList> getTags();
    public List<NamedTagEventList> buildTags();
    public NamedTagEventList buildTag(int index);
    public NamedTagEventList buildFirstTag();
    public NamedTagEventList buildLastTag();
    public NamedTagEventList buildMatchingTag(Predicate<NamedTagEventListBuilder> predicate);
    public Boolean hasMatchingTag(Predicate<NamedTagEventListBuilder> predicate);
    public A withTags(List<NamedTagEventList> tags);
    public A withTags(NamedTagEventList... tags);
    public Boolean hasTags();
    public ImageStreamStatusFluent.TagsNested<A> addNewTag();
    public ImageStreamStatusFluent.TagsNested<A> addNewTagLike(NamedTagEventList item);
    public ImageStreamStatusFluent.TagsNested<A> setNewTagLike(int index,NamedTagEventList item);
    public ImageStreamStatusFluent.TagsNested<A> editTag(int index);
    public ImageStreamStatusFluent.TagsNested<A> editFirstTag();
    public ImageStreamStatusFluent.TagsNested<A> editLastTag();
    public ImageStreamStatusFluent.TagsNested<A> editMatchingTag(Predicate<NamedTagEventListBuilder> predicate);
    public interface TagsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,NamedTagEventListFluent<ImageStreamStatusFluent.TagsNested<N>> {

            public N and();
            public N endTag();    }


}
