package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.model.EnvVar;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface JenkinsPipelineBuildStrategyFluent<A extends JenkinsPipelineBuildStrategyFluent<A>> extends Fluent<A> {


    public A addToEnv(int index,EnvVar item);
    public A setToEnv(int index,EnvVar item);
    public A addToEnv(EnvVar... items);
    public A addAllToEnv(Collection<EnvVar> items);
    public A removeFromEnv(EnvVar... items);
    public A removeAllFromEnv(Collection<EnvVar> items);
    public List<EnvVar> getEnv();
    public EnvVar getEnv(int index);
    public EnvVar getFirstEnv();
    public EnvVar getLastEnv();
    public EnvVar getMatchingEnv(Predicate<EnvVar> predicate);
    public Boolean hasMatchingEnv(Predicate<EnvVar> predicate);
    public A withEnv(List<EnvVar> env);
    public A withEnv(EnvVar... env);
    public Boolean hasEnv();
    public String getJenkinsfile();
    public A withJenkinsfile(String jenkinsfile);
    public Boolean hasJenkinsfile();
    public A withNewJenkinsfile(String arg1);
    public A withNewJenkinsfile(StringBuilder arg1);
    public A withNewJenkinsfile(StringBuffer arg1);
    public String getJenkinsfilePath();
    public A withJenkinsfilePath(String jenkinsfilePath);
    public Boolean hasJenkinsfilePath();
    public A withNewJenkinsfilePath(String arg1);
    public A withNewJenkinsfilePath(StringBuilder arg1);
    public A withNewJenkinsfilePath(StringBuffer arg1);
}
