package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KeystoneIdentityProviderBuilder extends KeystoneIdentityProviderFluentImpl<KeystoneIdentityProviderBuilder> implements VisitableBuilder<KeystoneIdentityProvider,KeystoneIdentityProviderBuilder> {

    KeystoneIdentityProviderFluent<?> fluent;
    Boolean validationEnabled;

    public KeystoneIdentityProviderBuilder() {
        this(true);
    }

    public KeystoneIdentityProviderBuilder(Boolean validationEnabled) {
        this(new KeystoneIdentityProvider(), validationEnabled);
    }

    public KeystoneIdentityProviderBuilder(KeystoneIdentityProviderFluent<?> fluent) {
        this(fluent, true);
    }

    public KeystoneIdentityProviderBuilder(KeystoneIdentityProviderFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new KeystoneIdentityProvider(), validationEnabled);
    }

    public KeystoneIdentityProviderBuilder(KeystoneIdentityProviderFluent<?> fluent,KeystoneIdentityProvider instance) {
        this(fluent, instance, true);
    }

    public KeystoneIdentityProviderBuilder(KeystoneIdentityProviderFluent<?> fluent,KeystoneIdentityProvider instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withCa(instance.getCa()); 
        fluent.withDomainName(instance.getDomainName()); 
        fluent.withTlsClientCert(instance.getTlsClientCert()); 
        fluent.withTlsClientKey(instance.getTlsClientKey()); 
        fluent.withUrl(instance.getUrl()); 
        this.validationEnabled = validationEnabled; 
    }

    public KeystoneIdentityProviderBuilder(KeystoneIdentityProvider instance) {
        this(instance,true);
    }

    public KeystoneIdentityProviderBuilder(KeystoneIdentityProvider instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withCa(instance.getCa()); 
        this.withDomainName(instance.getDomainName()); 
        this.withTlsClientCert(instance.getTlsClientCert()); 
        this.withTlsClientKey(instance.getTlsClientKey()); 
        this.withUrl(instance.getUrl()); 
        this.validationEnabled = validationEnabled; 
    }

    public KeystoneIdentityProvider build() {
        KeystoneIdentityProvider buildable = new KeystoneIdentityProvider(fluent.getCa(),fluent.getDomainName(),fluent.getTlsClientCert(),fluent.getTlsClientKey(),fluent.getUrl());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KeystoneIdentityProviderBuilder that = (KeystoneIdentityProviderBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
