package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class OAuthSpecBuilder extends OAuthSpecFluentImpl<OAuthSpecBuilder> implements VisitableBuilder<OAuthSpec,OAuthSpecBuilder> {

    OAuthSpecFluent<?> fluent;
    Boolean validationEnabled;

    public OAuthSpecBuilder() {
        this(true);
    }

    public OAuthSpecBuilder(Boolean validationEnabled) {
        this(new OAuthSpec(), validationEnabled);
    }

    public OAuthSpecBuilder(OAuthSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public OAuthSpecBuilder(OAuthSpecFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new OAuthSpec(), validationEnabled);
    }

    public OAuthSpecBuilder(OAuthSpecFluent<?> fluent,OAuthSpec instance) {
        this(fluent, instance, true);
    }

    public OAuthSpecBuilder(OAuthSpecFluent<?> fluent,OAuthSpec instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withIdentityProviders(instance.getIdentityProviders()); 
        fluent.withTemplates(instance.getTemplates()); 
        fluent.withTokenConfig(instance.getTokenConfig()); 
        this.validationEnabled = validationEnabled; 
    }

    public OAuthSpecBuilder(OAuthSpec instance) {
        this(instance,true);
    }

    public OAuthSpecBuilder(OAuthSpec instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withIdentityProviders(instance.getIdentityProviders()); 
        this.withTemplates(instance.getTemplates()); 
        this.withTokenConfig(instance.getTokenConfig()); 
        this.validationEnabled = validationEnabled; 
    }

    public OAuthSpec build() {
        OAuthSpec buildable = new OAuthSpec(fluent.getIdentityProviders(),fluent.getTemplates(),fluent.getTokenConfig());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        OAuthSpecBuilder that = (OAuthSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
