package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.util.Collection;
import java.lang.Object;

public class OAuthSpecFluentImpl<A extends OAuthSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements OAuthSpecFluent<A> {

    private List<IdentityProviderBuilder> identityProviders =  new ArrayList<IdentityProviderBuilder>();
    private OAuthTemplatesBuilder templates;
    private TokenConfigBuilder tokenConfig;

    public OAuthSpecFluentImpl() {
    }

    public OAuthSpecFluentImpl(OAuthSpec instance) {
        this.withIdentityProviders(instance.getIdentityProviders()); 
        this.withTemplates(instance.getTemplates()); 
        this.withTokenConfig(instance.getTokenConfig()); 
    }

    public A addToIdentityProviders(int index,IdentityProvider item) {
        if (this.identityProviders == null) {this.identityProviders = new ArrayList<IdentityProviderBuilder>();}
        IdentityProviderBuilder builder = new IdentityProviderBuilder(item);_visitables.get("identityProviders").add(index >= 0 ? index : _visitables.get("identityProviders").size(), builder);this.identityProviders.add(index >= 0 ? index : identityProviders.size(), builder); return (A)this;
    }

    public A setToIdentityProviders(int index,IdentityProvider item) {
        if (this.identityProviders == null) {this.identityProviders = new ArrayList<IdentityProviderBuilder>();}
        IdentityProviderBuilder builder = new IdentityProviderBuilder(item);
        if (index < 0 || index >= _visitables.get("identityProviders").size()) { _visitables.get("identityProviders").add(builder); } else { _visitables.get("identityProviders").set(index, builder);}
        if (index < 0 || index >= identityProviders.size()) { identityProviders.add(builder); } else { identityProviders.set(index, builder);}
         return (A)this;
    }

    public A addToIdentityProviders(IdentityProvider... items) {
        if (this.identityProviders == null) {this.identityProviders = new ArrayList<IdentityProviderBuilder>();}
        for (IdentityProvider item : items) {IdentityProviderBuilder builder = new IdentityProviderBuilder(item);_visitables.get("identityProviders").add(builder);this.identityProviders.add(builder);} return (A)this;
    }

    public A addAllToIdentityProviders(Collection<IdentityProvider> items) {
        if (this.identityProviders == null) {this.identityProviders = new ArrayList<IdentityProviderBuilder>();}
        for (IdentityProvider item : items) {IdentityProviderBuilder builder = new IdentityProviderBuilder(item);_visitables.get("identityProviders").add(builder);this.identityProviders.add(builder);} return (A)this;
    }

    public A removeFromIdentityProviders(IdentityProvider... items) {
        for (IdentityProvider item : items) {IdentityProviderBuilder builder = new IdentityProviderBuilder(item);_visitables.get("identityProviders").remove(builder);if (this.identityProviders != null) {this.identityProviders.remove(builder);}} return (A)this;
    }

    public A removeAllFromIdentityProviders(Collection<IdentityProvider> items) {
        for (IdentityProvider item : items) {IdentityProviderBuilder builder = new IdentityProviderBuilder(item);_visitables.get("identityProviders").remove(builder);if (this.identityProviders != null) {this.identityProviders.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromIdentityProviders(Predicate<IdentityProviderBuilder> predicate) {
        if (identityProviders == null) return (A) this;
        final Iterator<IdentityProviderBuilder> each = identityProviders.iterator();
        final List visitables = _visitables.get("identityProviders");
        while (each.hasNext()) {
          IdentityProviderBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildIdentityProviders instead.
 * @return The buildable object.
 */
@Deprecated public List<IdentityProvider> getIdentityProviders() {
        return build(identityProviders);
    }

    public List<IdentityProvider> buildIdentityProviders() {
        return build(identityProviders);
    }

    public IdentityProvider buildIdentityProvider(int index) {
        return this.identityProviders.get(index).build();
    }

    public IdentityProvider buildFirstIdentityProvider() {
        return this.identityProviders.get(0).build();
    }

    public IdentityProvider buildLastIdentityProvider() {
        return this.identityProviders.get(identityProviders.size() - 1).build();
    }

    public IdentityProvider buildMatchingIdentityProvider(Predicate<IdentityProviderBuilder> predicate) {
        for (IdentityProviderBuilder item: identityProviders) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingIdentityProvider(Predicate<IdentityProviderBuilder> predicate) {
        for (IdentityProviderBuilder item: identityProviders) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withIdentityProviders(List<IdentityProvider> identityProviders) {
        if (this.identityProviders != null) { _visitables.get("identityProviders").removeAll(this.identityProviders);}
        if (identityProviders != null) {this.identityProviders = new ArrayList<IdentityProviderBuilder>(); for (IdentityProvider item : identityProviders){this.addToIdentityProviders(item);}} else { this.identityProviders = null;} return (A) this;
    }

    public A withIdentityProviders(IdentityProvider... identityProviders) {
        if (this.identityProviders != null) {this.identityProviders.clear();}
        if (identityProviders != null) {for (IdentityProvider item :identityProviders){ this.addToIdentityProviders(item);}} return (A) this;
    }

    public Boolean hasIdentityProviders() {
        return identityProviders != null && !identityProviders.isEmpty();
    }

    public OAuthSpecFluent.IdentityProvidersNested<A> addNewIdentityProvider() {
        return new IdentityProvidersNestedImpl();
    }

    public OAuthSpecFluent.IdentityProvidersNested<A> addNewIdentityProviderLike(IdentityProvider item) {
        return new IdentityProvidersNestedImpl(-1, item);
    }

    public OAuthSpecFluent.IdentityProvidersNested<A> setNewIdentityProviderLike(int index,IdentityProvider item) {
        return new IdentityProvidersNestedImpl(index, item);
    }

    public OAuthSpecFluent.IdentityProvidersNested<A> editIdentityProvider(int index) {
        if (identityProviders.size() <= index) throw new RuntimeException("Can't edit identityProviders. Index exceeds size.");
        return setNewIdentityProviderLike(index, buildIdentityProvider(index));
    }

    public OAuthSpecFluent.IdentityProvidersNested<A> editFirstIdentityProvider() {
        if (identityProviders.size() == 0) throw new RuntimeException("Can't edit first identityProviders. The list is empty.");
        return setNewIdentityProviderLike(0, buildIdentityProvider(0));
    }

    public OAuthSpecFluent.IdentityProvidersNested<A> editLastIdentityProvider() {
        int index = identityProviders.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last identityProviders. The list is empty.");
        return setNewIdentityProviderLike(index, buildIdentityProvider(index));
    }

    public OAuthSpecFluent.IdentityProvidersNested<A> editMatchingIdentityProvider(Predicate<IdentityProviderBuilder> predicate) {
        int index = -1;
        for (int i=0;i<identityProviders.size();i++) { 
        if (predicate.test(identityProviders.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching identityProviders. No match found.");
        return setNewIdentityProviderLike(index, buildIdentityProvider(index));
    }

    
/**
 * This method has been deprecated, please use method buildTemplates instead.
 * @return The buildable object.
 */
@Deprecated public OAuthTemplates getTemplates() {
        return this.templates!=null?this.templates.build():null;
    }

    public OAuthTemplates buildTemplates() {
        return this.templates!=null?this.templates.build():null;
    }

    public A withTemplates(OAuthTemplates templates) {
        _visitables.get("templates").remove(this.templates);
        if (templates!=null){ this.templates= new OAuthTemplatesBuilder(templates); _visitables.get("templates").add(this.templates);} return (A) this;
    }

    public Boolean hasTemplates() {
        return this.templates != null;
    }

    public OAuthSpecFluent.TemplatesNested<A> withNewTemplates() {
        return new TemplatesNestedImpl();
    }

    public OAuthSpecFluent.TemplatesNested<A> withNewTemplatesLike(OAuthTemplates item) {
        return new TemplatesNestedImpl(item);
    }

    public OAuthSpecFluent.TemplatesNested<A> editTemplates() {
        return withNewTemplatesLike(getTemplates());
    }

    public OAuthSpecFluent.TemplatesNested<A> editOrNewTemplates() {
        return withNewTemplatesLike(getTemplates() != null ? getTemplates(): new OAuthTemplatesBuilder().build());
    }

    public OAuthSpecFluent.TemplatesNested<A> editOrNewTemplatesLike(OAuthTemplates item) {
        return withNewTemplatesLike(getTemplates() != null ? getTemplates(): item);
    }

    
/**
 * This method has been deprecated, please use method buildTokenConfig instead.
 * @return The buildable object.
 */
@Deprecated public TokenConfig getTokenConfig() {
        return this.tokenConfig!=null?this.tokenConfig.build():null;
    }

    public TokenConfig buildTokenConfig() {
        return this.tokenConfig!=null?this.tokenConfig.build():null;
    }

    public A withTokenConfig(TokenConfig tokenConfig) {
        _visitables.get("tokenConfig").remove(this.tokenConfig);
        if (tokenConfig!=null){ this.tokenConfig= new TokenConfigBuilder(tokenConfig); _visitables.get("tokenConfig").add(this.tokenConfig);} return (A) this;
    }

    public Boolean hasTokenConfig() {
        return this.tokenConfig != null;
    }

    public OAuthSpecFluent.TokenConfigNested<A> withNewTokenConfig() {
        return new TokenConfigNestedImpl();
    }

    public OAuthSpecFluent.TokenConfigNested<A> withNewTokenConfigLike(TokenConfig item) {
        return new TokenConfigNestedImpl(item);
    }

    public OAuthSpecFluent.TokenConfigNested<A> editTokenConfig() {
        return withNewTokenConfigLike(getTokenConfig());
    }

    public OAuthSpecFluent.TokenConfigNested<A> editOrNewTokenConfig() {
        return withNewTokenConfigLike(getTokenConfig() != null ? getTokenConfig(): new TokenConfigBuilder().build());
    }

    public OAuthSpecFluent.TokenConfigNested<A> editOrNewTokenConfigLike(TokenConfig item) {
        return withNewTokenConfigLike(getTokenConfig() != null ? getTokenConfig(): item);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        OAuthSpecFluentImpl that = (OAuthSpecFluentImpl) o;
        if (identityProviders != null ? !identityProviders.equals(that.identityProviders) :that.identityProviders != null) return false;
        if (templates != null ? !templates.equals(that.templates) :that.templates != null) return false;
        if (tokenConfig != null ? !tokenConfig.equals(that.tokenConfig) :that.tokenConfig != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(identityProviders,  templates,  tokenConfig,  super.hashCode());
    }

    public class IdentityProvidersNestedImpl<N> extends IdentityProviderFluentImpl<OAuthSpecFluent.IdentityProvidersNested<N>> implements OAuthSpecFluent.IdentityProvidersNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final IdentityProviderBuilder builder;
        private final int index;

            IdentityProvidersNestedImpl(int index,IdentityProvider item) {
                this.index = index;
                this.builder = new IdentityProviderBuilder(this, item);
                        
            }

            IdentityProvidersNestedImpl() {
                this.index = -1;
                this.builder = new IdentityProviderBuilder(this);
                        
            }

            public N and() {
                return (N) OAuthSpecFluentImpl.this.setToIdentityProviders(index,builder.build());
            }

            public N endIdentityProvider() {
                return and();
            }
    }


    public class TemplatesNestedImpl<N> extends OAuthTemplatesFluentImpl<OAuthSpecFluent.TemplatesNested<N>> implements OAuthSpecFluent.TemplatesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final OAuthTemplatesBuilder builder;

            TemplatesNestedImpl(OAuthTemplates item) {
                this.builder = new OAuthTemplatesBuilder(this, item);
                        
            }

            TemplatesNestedImpl() {
                this.builder = new OAuthTemplatesBuilder(this);
                        
            }

            public N and() {
                return (N) OAuthSpecFluentImpl.this.withTemplates(builder.build());
            }

            public N endTemplates() {
                return and();
            }
    }


    public class TokenConfigNestedImpl<N> extends TokenConfigFluentImpl<OAuthSpecFluent.TokenConfigNested<N>> implements OAuthSpecFluent.TokenConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final TokenConfigBuilder builder;

            TokenConfigNestedImpl(TokenConfig item) {
                this.builder = new TokenConfigBuilder(this, item);
                        
            }

            TokenConfigNestedImpl() {
                this.builder = new TokenConfigBuilder(this);
                        
            }

            public N and() {
                return (N) OAuthSpecFluentImpl.this.withTokenConfig(builder.build());
            }

            public N endTokenConfig() {
                return and();
            }
    }


}
