package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface APIServerServingCertsFluent<A extends APIServerServingCertsFluent<A>> extends Fluent<A> {


    public A addToNamedCertificates(int index,APIServerNamedServingCert item);
    public A setToNamedCertificates(int index,APIServerNamedServingCert item);
    public A addToNamedCertificates(APIServerNamedServingCert... items);
    public A addAllToNamedCertificates(Collection<APIServerNamedServingCert> items);
    public A removeFromNamedCertificates(APIServerNamedServingCert... items);
    public A removeAllFromNamedCertificates(Collection<APIServerNamedServingCert> items);
    public A removeMatchingFromNamedCertificates(Predicate<APIServerNamedServingCertBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildNamedCertificates instead.
 * @return The buildable object.
 */
@Deprecated public List<APIServerNamedServingCert> getNamedCertificates();
    public List<APIServerNamedServingCert> buildNamedCertificates();
    public APIServerNamedServingCert buildNamedCertificate(int index);
    public APIServerNamedServingCert buildFirstNamedCertificate();
    public APIServerNamedServingCert buildLastNamedCertificate();
    public APIServerNamedServingCert buildMatchingNamedCertificate(Predicate<APIServerNamedServingCertBuilder> predicate);
    public Boolean hasMatchingNamedCertificate(Predicate<APIServerNamedServingCertBuilder> predicate);
    public A withNamedCertificates(List<APIServerNamedServingCert> namedCertificates);
    public A withNamedCertificates(APIServerNamedServingCert... namedCertificates);
    public Boolean hasNamedCertificates();
    public APIServerServingCertsFluent.NamedCertificatesNested<A> addNewNamedCertificate();
    public APIServerServingCertsFluent.NamedCertificatesNested<A> addNewNamedCertificateLike(APIServerNamedServingCert item);
    public APIServerServingCertsFluent.NamedCertificatesNested<A> setNewNamedCertificateLike(int index,APIServerNamedServingCert item);
    public APIServerServingCertsFluent.NamedCertificatesNested<A> editNamedCertificate(int index);
    public APIServerServingCertsFluent.NamedCertificatesNested<A> editFirstNamedCertificate();
    public APIServerServingCertsFluent.NamedCertificatesNested<A> editLastNamedCertificate();
    public APIServerServingCertsFluent.NamedCertificatesNested<A> editMatchingNamedCertificate(Predicate<APIServerNamedServingCertBuilder> predicate);
    public interface NamedCertificatesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,APIServerNamedServingCertFluent<APIServerServingCertsFluent.NamedCertificatesNested<N>> {

            public N and();
            public N endNamedCertificate();    }


}
