package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class BareMetalPlatformSpecBuilder extends BareMetalPlatformSpecFluentImpl<BareMetalPlatformSpecBuilder> implements VisitableBuilder<BareMetalPlatformSpec,BareMetalPlatformSpecBuilder> {

    BareMetalPlatformSpecFluent<?> fluent;
    Boolean validationEnabled;

    public BareMetalPlatformSpecBuilder() {
        this(true);
    }

    public BareMetalPlatformSpecBuilder(Boolean validationEnabled) {
        this(new BareMetalPlatformSpec(), validationEnabled);
    }

    public BareMetalPlatformSpecBuilder(BareMetalPlatformSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public BareMetalPlatformSpecBuilder(BareMetalPlatformSpecFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new BareMetalPlatformSpec(), validationEnabled);
    }

    public BareMetalPlatformSpecBuilder(BareMetalPlatformSpecFluent<?> fluent,BareMetalPlatformSpec instance) {
        this(fluent, instance, true);
    }

    public BareMetalPlatformSpecBuilder(BareMetalPlatformSpecFluent<?> fluent,BareMetalPlatformSpec instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        this.validationEnabled = validationEnabled; 
    }

    public BareMetalPlatformSpecBuilder(BareMetalPlatformSpec instance) {
        this(instance,true);
    }

    public BareMetalPlatformSpecBuilder(BareMetalPlatformSpec instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.validationEnabled = validationEnabled; 
    }

    public BareMetalPlatformSpec build() {
        BareMetalPlatformSpec buildable = new BareMetalPlatformSpec();
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        BareMetalPlatformSpecBuilder that = (BareMetalPlatformSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
