package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class OpenIDClaimsBuilder extends OpenIDClaimsFluentImpl<OpenIDClaimsBuilder> implements VisitableBuilder<OpenIDClaims,OpenIDClaimsBuilder> {

    OpenIDClaimsFluent<?> fluent;
    Boolean validationEnabled;

    public OpenIDClaimsBuilder() {
        this(true);
    }

    public OpenIDClaimsBuilder(Boolean validationEnabled) {
        this(new OpenIDClaims(), validationEnabled);
    }

    public OpenIDClaimsBuilder(OpenIDClaimsFluent<?> fluent) {
        this(fluent, true);
    }

    public OpenIDClaimsBuilder(OpenIDClaimsFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new OpenIDClaims(), validationEnabled);
    }

    public OpenIDClaimsBuilder(OpenIDClaimsFluent<?> fluent,OpenIDClaims instance) {
        this(fluent, instance, true);
    }

    public OpenIDClaimsBuilder(OpenIDClaimsFluent<?> fluent,OpenIDClaims instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withEmail(instance.getEmail()); 
        fluent.withName(instance.getName()); 
        fluent.withPreferredUsername(instance.getPreferredUsername()); 
        this.validationEnabled = validationEnabled; 
    }

    public OpenIDClaimsBuilder(OpenIDClaims instance) {
        this(instance,true);
    }

    public OpenIDClaimsBuilder(OpenIDClaims instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withEmail(instance.getEmail()); 
        this.withName(instance.getName()); 
        this.withPreferredUsername(instance.getPreferredUsername()); 
        this.validationEnabled = validationEnabled; 
    }

    public OpenIDClaims build() {
        OpenIDClaims buildable = new OpenIDClaims(fluent.getEmail(),fluent.getName(),fluent.getPreferredUsername());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        OpenIDClaimsBuilder that = (OpenIDClaimsBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
