package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class RangeAllocationBuilder extends RangeAllocationFluentImpl<RangeAllocationBuilder> implements VisitableBuilder<RangeAllocation,RangeAllocationBuilder> {

    RangeAllocationFluent<?> fluent;
    Boolean validationEnabled;

    public RangeAllocationBuilder() {
        this(true);
    }

    public RangeAllocationBuilder(Boolean validationEnabled) {
        this(new RangeAllocation(), validationEnabled);
    }

    public RangeAllocationBuilder(RangeAllocationFluent<?> fluent) {
        this(fluent, true);
    }

    public RangeAllocationBuilder(RangeAllocationFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new RangeAllocation(), validationEnabled);
    }

    public RangeAllocationBuilder(RangeAllocationFluent<?> fluent,RangeAllocation instance) {
        this(fluent, instance, true);
    }

    public RangeAllocationBuilder(RangeAllocationFluent<?> fluent,RangeAllocation instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withData(instance.getData()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        fluent.withRange(instance.getRange()); 
        this.validationEnabled = validationEnabled; 
    }

    public RangeAllocationBuilder(RangeAllocation instance) {
        this(instance,true);
    }

    public RangeAllocationBuilder(RangeAllocation instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withData(instance.getData()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withRange(instance.getRange()); 
        this.validationEnabled = validationEnabled; 
    }

    public RangeAllocation build() {
        RangeAllocation buildable = new RangeAllocation(fluent.getApiVersion(),fluent.getData(),fluent.getKind(),fluent.getMetadata(),fluent.getRange());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        RangeAllocationBuilder that = (RangeAllocationBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
