package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class SelfSubjectRulesReviewFluentImpl<A extends SelfSubjectRulesReviewFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements SelfSubjectRulesReviewFluent<A> {

    private String apiVersion;
    private String kind;
    private SelfSubjectRulesReviewSpecBuilder spec;
    private SubjectRulesReviewStatusBuilder status;

    public SelfSubjectRulesReviewFluentImpl() {
    }

    public SelfSubjectRulesReviewFluentImpl(SelfSubjectRulesReview instance) {
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withSpec(instance.getSpec()); 
        this.withStatus(instance.getStatus()); 
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public A withNewApiVersion(String arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuilder arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuffer arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind=kind; return (A) this;
    }

    public Boolean hasKind() {
        return this.kind != null;
    }

    public A withNewKind(String arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuilder arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuffer arg1) {
        return (A)withKind(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public SelfSubjectRulesReviewSpec getSpec() {
        return this.spec!=null?this.spec.build():null;
    }

    public SelfSubjectRulesReviewSpec buildSpec() {
        return this.spec!=null?this.spec.build():null;
    }

    public A withSpec(SelfSubjectRulesReviewSpec spec) {
        _visitables.get("spec").remove(this.spec);
        if (spec!=null){ this.spec= new SelfSubjectRulesReviewSpecBuilder(spec); _visitables.get("spec").add(this.spec);} return (A) this;
    }

    public Boolean hasSpec() {
        return this.spec != null;
    }

    public SelfSubjectRulesReviewFluent.SpecNested<A> withNewSpec() {
        return new SpecNestedImpl();
    }

    public SelfSubjectRulesReviewFluent.SpecNested<A> withNewSpecLike(SelfSubjectRulesReviewSpec item) {
        return new SpecNestedImpl(item);
    }

    public SelfSubjectRulesReviewFluent.SpecNested<A> editSpec() {
        return withNewSpecLike(getSpec());
    }

    public SelfSubjectRulesReviewFluent.SpecNested<A> editOrNewSpec() {
        return withNewSpecLike(getSpec() != null ? getSpec(): new SelfSubjectRulesReviewSpecBuilder().build());
    }

    public SelfSubjectRulesReviewFluent.SpecNested<A> editOrNewSpecLike(SelfSubjectRulesReviewSpec item) {
        return withNewSpecLike(getSpec() != null ? getSpec(): item);
    }

    
/**
 * This method has been deprecated, please use method buildStatus instead.
 * @return The buildable object.
 */
@Deprecated public SubjectRulesReviewStatus getStatus() {
        return this.status!=null?this.status.build():null;
    }

    public SubjectRulesReviewStatus buildStatus() {
        return this.status!=null?this.status.build():null;
    }

    public A withStatus(SubjectRulesReviewStatus status) {
        _visitables.get("status").remove(this.status);
        if (status!=null){ this.status= new SubjectRulesReviewStatusBuilder(status); _visitables.get("status").add(this.status);} return (A) this;
    }

    public Boolean hasStatus() {
        return this.status != null;
    }

    public SelfSubjectRulesReviewFluent.StatusNested<A> withNewStatus() {
        return new StatusNestedImpl();
    }

    public SelfSubjectRulesReviewFluent.StatusNested<A> withNewStatusLike(SubjectRulesReviewStatus item) {
        return new StatusNestedImpl(item);
    }

    public SelfSubjectRulesReviewFluent.StatusNested<A> editStatus() {
        return withNewStatusLike(getStatus());
    }

    public SelfSubjectRulesReviewFluent.StatusNested<A> editOrNewStatus() {
        return withNewStatusLike(getStatus() != null ? getStatus(): new SubjectRulesReviewStatusBuilder().build());
    }

    public SelfSubjectRulesReviewFluent.StatusNested<A> editOrNewStatusLike(SubjectRulesReviewStatus item) {
        return withNewStatusLike(getStatus() != null ? getStatus(): item);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        SelfSubjectRulesReviewFluentImpl that = (SelfSubjectRulesReviewFluentImpl) o;
        if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
        if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
        if (spec != null ? !spec.equals(that.spec) :that.spec != null) return false;
        if (status != null ? !status.equals(that.status) :that.status != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(apiVersion,  kind,  spec,  status,  super.hashCode());
    }

    public class SpecNestedImpl<N> extends SelfSubjectRulesReviewSpecFluentImpl<SelfSubjectRulesReviewFluent.SpecNested<N>> implements SelfSubjectRulesReviewFluent.SpecNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final SelfSubjectRulesReviewSpecBuilder builder;

            SpecNestedImpl(SelfSubjectRulesReviewSpec item) {
                this.builder = new SelfSubjectRulesReviewSpecBuilder(this, item);
                        
            }

            SpecNestedImpl() {
                this.builder = new SelfSubjectRulesReviewSpecBuilder(this);
                        
            }

            public N and() {
                return (N) SelfSubjectRulesReviewFluentImpl.this.withSpec(builder.build());
            }

            public N endSpec() {
                return and();
            }
    }


    public class StatusNestedImpl<N> extends SubjectRulesReviewStatusFluentImpl<SelfSubjectRulesReviewFluent.StatusNested<N>> implements SelfSubjectRulesReviewFluent.StatusNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final SubjectRulesReviewStatusBuilder builder;

            StatusNestedImpl(SubjectRulesReviewStatus item) {
                this.builder = new SubjectRulesReviewStatusBuilder(this, item);
                        
            }

            StatusNestedImpl() {
                this.builder = new SubjectRulesReviewStatusBuilder(this);
                        
            }

            public N and() {
                return (N) SelfSubjectRulesReviewFluentImpl.this.withStatus(builder.build());
            }

            public N endStatus() {
                return and();
            }
    }


}
