package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public interface ClusterVersionFluent<A extends ClusterVersionFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public ClusterVersionFluent.MetadataNested<A> withNewMetadata();
    public ClusterVersionFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public ClusterVersionFluent.MetadataNested<A> editMetadata();
    public ClusterVersionFluent.MetadataNested<A> editOrNewMetadata();
    public ClusterVersionFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public ClusterVersionSpec getSpec();
    public ClusterVersionSpec buildSpec();
    public A withSpec(ClusterVersionSpec spec);
    public Boolean hasSpec();
    public ClusterVersionFluent.SpecNested<A> withNewSpec();
    public ClusterVersionFluent.SpecNested<A> withNewSpecLike(ClusterVersionSpec item);
    public ClusterVersionFluent.SpecNested<A> editSpec();
    public ClusterVersionFluent.SpecNested<A> editOrNewSpec();
    public ClusterVersionFluent.SpecNested<A> editOrNewSpecLike(ClusterVersionSpec item);
    
/**
 * This method has been deprecated, please use method buildStatus instead.
 * @return The buildable object.
 */
@Deprecated public ClusterVersionStatus getStatus();
    public ClusterVersionStatus buildStatus();
    public A withStatus(ClusterVersionStatus status);
    public Boolean hasStatus();
    public ClusterVersionFluent.StatusNested<A> withNewStatus();
    public ClusterVersionFluent.StatusNested<A> withNewStatusLike(ClusterVersionStatus item);
    public ClusterVersionFluent.StatusNested<A> editStatus();
    public ClusterVersionFluent.StatusNested<A> editOrNewStatus();
    public ClusterVersionFluent.StatusNested<A> editOrNewStatusLike(ClusterVersionStatus item);
    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<ClusterVersionFluent.MetadataNested<N>> {

            public N and();
            public N endMetadata();    }


    public interface SpecNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ClusterVersionSpecFluent<ClusterVersionFluent.SpecNested<N>> {

            public N and();
            public N endSpec();    }


    public interface StatusNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ClusterVersionStatusFluent<ClusterVersionFluent.StatusNested<N>> {

            public N and();
            public N endStatus();    }


}
