package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.StringBuffer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;

public class ImageListFluentImpl<A extends ImageListFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ImageListFluent<A> {

    private String apiVersion;
    private List<ImageBuilder> items =  new ArrayList<ImageBuilder>();
    private String kind;
    private ListMeta metadata;

    public ImageListFluentImpl() {
    }

    public ImageListFluentImpl(ImageList instance) {
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public A withNewApiVersion(String arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuilder arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuffer arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A addToItems(int index,Image item) {
        if (this.items == null) {this.items = new ArrayList<ImageBuilder>();}
        ImageBuilder builder = new ImageBuilder(item);_visitables.get("items").add(index >= 0 ? index : _visitables.get("items").size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
    }

    public A setToItems(int index,Image item) {
        if (this.items == null) {this.items = new ArrayList<ImageBuilder>();}
        ImageBuilder builder = new ImageBuilder(item);
        if (index < 0 || index >= _visitables.get("items").size()) { _visitables.get("items").add(builder); } else { _visitables.get("items").set(index, builder);}
        if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
         return (A)this;
    }

    public A addToItems(Image... items) {
        if (this.items == null) {this.items = new ArrayList<ImageBuilder>();}
        for (Image item : items) {ImageBuilder builder = new ImageBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
    }

    public A addAllToItems(Collection<Image> items) {
        if (this.items == null) {this.items = new ArrayList<ImageBuilder>();}
        for (Image item : items) {ImageBuilder builder = new ImageBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromItems(Image... items) {
        for (Image item : items) {ImageBuilder builder = new ImageBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
    }

    public A removeAllFromItems(Collection<Image> items) {
        for (Image item : items) {ImageBuilder builder = new ImageBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromItems(Predicate<ImageBuilder> predicate) {
        if (items == null) return (A) this;
        final Iterator<ImageBuilder> each = items.iterator();
        final List visitables = _visitables.get("items");
        while (each.hasNext()) {
          ImageBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<Image> getItems() {
        return build(items);
    }

    public List<Image> buildItems() {
        return build(items);
    }

    public Image buildItem(int index) {
        return this.items.get(index).build();
    }

    public Image buildFirstItem() {
        return this.items.get(0).build();
    }

    public Image buildLastItem() {
        return this.items.get(items.size() - 1).build();
    }

    public Image buildMatchingItem(Predicate<ImageBuilder> predicate) {
        for (ImageBuilder item: items) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingItem(Predicate<ImageBuilder> predicate) {
        for (ImageBuilder item: items) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withItems(List<Image> items) {
        if (this.items != null) { _visitables.get("items").removeAll(this.items);}
        if (items != null) {this.items = new ArrayList<ImageBuilder>(); for (Image item : items){this.addToItems(item);}} else { this.items = null;} return (A) this;
    }

    public A withItems(Image... items) {
        if (this.items != null) {this.items.clear();}
        if (items != null) {for (Image item :items){ this.addToItems(item);}} return (A) this;
    }

    public Boolean hasItems() {
        return items != null && !items.isEmpty();
    }

    public ImageListFluent.ItemsNested<A> addNewItem() {
        return new ItemsNestedImpl();
    }

    public ImageListFluent.ItemsNested<A> addNewItemLike(Image item) {
        return new ItemsNestedImpl(-1, item);
    }

    public ImageListFluent.ItemsNested<A> setNewItemLike(int index,Image item) {
        return new ItemsNestedImpl(index, item);
    }

    public ImageListFluent.ItemsNested<A> editItem(int index) {
        if (items.size() <= index) throw new RuntimeException("Can't edit items. Index exceeds size.");
        return setNewItemLike(index, buildItem(index));
    }

    public ImageListFluent.ItemsNested<A> editFirstItem() {
        if (items.size() == 0) throw new RuntimeException("Can't edit first items. The list is empty.");
        return setNewItemLike(0, buildItem(0));
    }

    public ImageListFluent.ItemsNested<A> editLastItem() {
        int index = items.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last items. The list is empty.");
        return setNewItemLike(index, buildItem(index));
    }

    public ImageListFluent.ItemsNested<A> editMatchingItem(Predicate<ImageBuilder> predicate) {
        int index = -1;
        for (int i=0;i<items.size();i++) { 
        if (predicate.test(items.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching items. No match found.");
        return setNewItemLike(index, buildItem(index));
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind=kind; return (A) this;
    }

    public Boolean hasKind() {
        return this.kind != null;
    }

    public A withNewKind(String arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuilder arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuffer arg1) {
        return (A)withKind(new String(arg1));
    }

    public ListMeta getMetadata() {
        return this.metadata;
    }

    public A withMetadata(ListMeta metadata) {
        this.metadata=metadata; return (A) this;
    }

    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink) {
        return (A)withMetadata(new ListMeta(_continue, remainingItemCount, resourceVersion, selfLink));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ImageListFluentImpl that = (ImageListFluentImpl) o;
        if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
        if (items != null ? !items.equals(that.items) :that.items != null) return false;
        if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
        if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(apiVersion,  items,  kind,  metadata,  super.hashCode());
    }

    public class ItemsNestedImpl<N> extends ImageFluentImpl<ImageListFluent.ItemsNested<N>> implements ImageListFluent.ItemsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ImageBuilder builder;
        private final int index;

            ItemsNestedImpl(int index,Image item) {
                this.index = index;
                this.builder = new ImageBuilder(this, item);
                        
            }

            ItemsNestedImpl() {
                this.index = -1;
                this.builder = new ImageBuilder(this);
                        
            }

            public N and() {
                return (N) ImageListFluentImpl.this.setToItems(index,builder.build());
            }

            public N endItem() {
                return and();
            }
    }


}
