package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class InfrastructureBuilder extends InfrastructureFluentImpl<InfrastructureBuilder> implements VisitableBuilder<Infrastructure,InfrastructureBuilder> {

    InfrastructureFluent<?> fluent;
    Boolean validationEnabled;

    public InfrastructureBuilder() {
        this(true);
    }

    public InfrastructureBuilder(Boolean validationEnabled) {
        this(new Infrastructure(), validationEnabled);
    }

    public InfrastructureBuilder(InfrastructureFluent<?> fluent) {
        this(fluent, true);
    }

    public InfrastructureBuilder(InfrastructureFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new Infrastructure(), validationEnabled);
    }

    public InfrastructureBuilder(InfrastructureFluent<?> fluent,Infrastructure instance) {
        this(fluent, instance, true);
    }

    public InfrastructureBuilder(InfrastructureFluent<?> fluent,Infrastructure instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        fluent.withSpec(instance.getSpec()); 
        fluent.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public InfrastructureBuilder(Infrastructure instance) {
        this(instance,true);
    }

    public InfrastructureBuilder(Infrastructure instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withSpec(instance.getSpec()); 
        this.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public Infrastructure build() {
        Infrastructure buildable = new Infrastructure(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        InfrastructureBuilder that = (InfrastructureBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
