package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class PodSecurityPolicySelfSubjectReviewSpecBuilder extends PodSecurityPolicySelfSubjectReviewSpecFluentImpl<PodSecurityPolicySelfSubjectReviewSpecBuilder> implements VisitableBuilder<PodSecurityPolicySelfSubjectReviewSpec,PodSecurityPolicySelfSubjectReviewSpecBuilder> {

    PodSecurityPolicySelfSubjectReviewSpecFluent<?> fluent;
    Boolean validationEnabled;

    public PodSecurityPolicySelfSubjectReviewSpecBuilder() {
        this(true);
    }

    public PodSecurityPolicySelfSubjectReviewSpecBuilder(Boolean validationEnabled) {
        this(new PodSecurityPolicySelfSubjectReviewSpec(), validationEnabled);
    }

    public PodSecurityPolicySelfSubjectReviewSpecBuilder(PodSecurityPolicySelfSubjectReviewSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public PodSecurityPolicySelfSubjectReviewSpecBuilder(PodSecurityPolicySelfSubjectReviewSpecFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new PodSecurityPolicySelfSubjectReviewSpec(), validationEnabled);
    }

    public PodSecurityPolicySelfSubjectReviewSpecBuilder(PodSecurityPolicySelfSubjectReviewSpecFluent<?> fluent,PodSecurityPolicySelfSubjectReviewSpec instance) {
        this(fluent, instance, true);
    }

    public PodSecurityPolicySelfSubjectReviewSpecBuilder(PodSecurityPolicySelfSubjectReviewSpecFluent<?> fluent,PodSecurityPolicySelfSubjectReviewSpec instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withTemplate(instance.getTemplate()); 
        this.validationEnabled = validationEnabled; 
    }

    public PodSecurityPolicySelfSubjectReviewSpecBuilder(PodSecurityPolicySelfSubjectReviewSpec instance) {
        this(instance,true);
    }

    public PodSecurityPolicySelfSubjectReviewSpecBuilder(PodSecurityPolicySelfSubjectReviewSpec instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withTemplate(instance.getTemplate()); 
        this.validationEnabled = validationEnabled; 
    }

    public PodSecurityPolicySelfSubjectReviewSpec build() {
        PodSecurityPolicySelfSubjectReviewSpec buildable = new PodSecurityPolicySelfSubjectReviewSpec(fluent.getTemplate());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        PodSecurityPolicySelfSubjectReviewSpecBuilder that = (PodSecurityPolicySelfSubjectReviewSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
