package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class TokenConfigBuilder extends TokenConfigFluentImpl<TokenConfigBuilder> implements VisitableBuilder<TokenConfig,TokenConfigBuilder> {

    TokenConfigFluent<?> fluent;
    Boolean validationEnabled;

    public TokenConfigBuilder() {
        this(true);
    }

    public TokenConfigBuilder(Boolean validationEnabled) {
        this(new TokenConfig(), validationEnabled);
    }

    public TokenConfigBuilder(TokenConfigFluent<?> fluent) {
        this(fluent, true);
    }

    public TokenConfigBuilder(TokenConfigFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new TokenConfig(), validationEnabled);
    }

    public TokenConfigBuilder(TokenConfigFluent<?> fluent,TokenConfig instance) {
        this(fluent, instance, true);
    }

    public TokenConfigBuilder(TokenConfigFluent<?> fluent,TokenConfig instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withAccessTokenInactivityTimeout(instance.getAccessTokenInactivityTimeout()); 
        fluent.withAccessTokenInactivityTimeoutSeconds(instance.getAccessTokenInactivityTimeoutSeconds()); 
        fluent.withAccessTokenMaxAgeSeconds(instance.getAccessTokenMaxAgeSeconds()); 
        this.validationEnabled = validationEnabled; 
    }

    public TokenConfigBuilder(TokenConfig instance) {
        this(instance,true);
    }

    public TokenConfigBuilder(TokenConfig instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withAccessTokenInactivityTimeout(instance.getAccessTokenInactivityTimeout()); 
        this.withAccessTokenInactivityTimeoutSeconds(instance.getAccessTokenInactivityTimeoutSeconds()); 
        this.withAccessTokenMaxAgeSeconds(instance.getAccessTokenMaxAgeSeconds()); 
        this.validationEnabled = validationEnabled; 
    }

    public TokenConfig build() {
        TokenConfig buildable = new TokenConfig(fluent.getAccessTokenInactivityTimeout(),fluent.getAccessTokenInactivityTimeoutSeconds(),fluent.getAccessTokenMaxAgeSeconds());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        TokenConfigBuilder that = (TokenConfigBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
